/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ome.model.IObject;
import ome.model.containers.Category;
import ome.model.containers.CategoryGroup;
import ome.model.core.Image;
import ome.util.CBlock;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.ImageData;
import pojos.SetMutator;

public class CategoryData
extends DataObject {
    public static final String NAME = "Category_name";
    public static final String DESCRIPTION = "Category_description";
    public static final String IMAGES = "Category_imageLinks";
    public static final String CATEGORY_GROUP_LINKS = "Category_categoryGroupLinks";
    private Set images;
    private CategoryGroupData group;

    public CategoryData() {
        this.setDirty(true);
        this.setValue((IObject)new Category());
    }

    public CategoryData(Category category) {
        if (category == null) {
            throw new IllegalArgumentException("Category cannot null.");
        }
        this.setValue((IObject)category);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asCategory().setName(name);
    }

    public String getName() {
        return this.asCategory().getName();
    }

    public void setDescription(String description) {
        this.setDirty(true);
        this.asCategory().setDescription(description);
    }

    public String getDescription() {
        return this.asCategory().getDescription();
    }

    public CategoryGroupData getGroup() {
        List list;
        if (this.group == null && this.asCategory().sizeOfCategoryGroupLinks() >= 0 && (list = this.asCategory().linkedCategoryGroupList()) != null && list.size() > 0) {
            this.group = new CategoryGroupData((CategoryGroup)list.get(0));
        }
        return this.group;
    }

    public void setGroup(CategoryGroupData group) {
        if (group == this.getGroup()) {
            return;
        }
        this.setDirty(true);
        this.group = group;
        this.asCategory().clearCategoryGroupLinks();
        if (group != null) {
            this.asCategory().linkCategoryGroup(group.asCategoryGroup());
        }
    }

    public Set getImages() {
        if (this.images == null && this.asCategory().sizeOfImageLinks() >= 0) {
            this.images = new HashSet(this.asCategory().eachLinkedImage(new CBlock(){

                public Object call(IObject object) {
                    return new ImageData((Image)object);
                }
            }));
        }
        return this.images == null ? null : new HashSet(this.images);
    }

    public void setImages(Set newValue) {
        Set categories;
        ImageData imgData;
        Set currentValue = this.getImages();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            imgData = (ImageData)m.nextAddition();
            this.asCategory().unlinkImage(imgData.asImage());
            categories = imgData.getCategories();
            categories.remove(this);
            imgData.setCategories(categories);
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            imgData = (ImageData)m.nextAddition();
            this.asCategory().linkImage(imgData.asImage());
            categories = imgData.getCategories();
            categories.add(this);
            imgData.setCategories(categories);
        }
        this.images = m.result();
    }
}

