/*
 * Decompiled with CFR 0.152.
 */
package ome.client;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import ome.model.IObject;

public class Storage {
    protected Map created = new LinkedHashMap();
    protected Map persistent = new LinkedHashMap();
    protected Map deleted = new LinkedHashMap();
    protected Map dirty = new LinkedHashMap();

    public IObject[] copyCreatedEntities() {
        Set c = this.created.keySet();
        return c.toArray(new IObject[c.size()]);
    }

    public IObject[] copyPersistentEntities() {
        Collection c = this.persistent.values();
        return c.toArray(new IObject[c.size()]);
    }

    public IObject[] copyDirtyEntities() {
        Collection c = this.dirty.values();
        return c.toArray(new IObject[c.size()]);
    }

    public IObject[] copyDeletedEntities() {
        Collection c = this.deleted.values();
        return c.toArray(new IObject[c.size()]);
    }

    public boolean isTransient(IObject iObject) {
        if (iObject == null) {
            return false;
        }
        return this.created.containsKey(iObject);
    }

    public boolean hasReplacement(IObject iObject) {
        return this.isTransient(iObject) && this.created.get(iObject) != null;
    }

    public IObject getReplacement(IObject iObject) {
        if (iObject == null) {
            return null;
        }
        return (IObject)this.created.get(iObject);
    }

    public IObject findPersistent(Class klass, Long id) {
        if (klass == null || id == null) {
            return null;
        }
        return (IObject)this.persistent.get(new Key(klass, id));
    }

    public boolean isPersistent(Class klass, Long id) {
        if (klass == null || id == null) {
            return false;
        }
        return this.persistent.containsKey(new Key(klass, id));
    }

    public boolean isDeleted(Class klass, Long id) {
        if (klass == null || id == null) {
            return false;
        }
        return this.deleted.containsKey(new Key(klass, id));
    }

    public boolean isDirty(Class klass, Long id) {
        if (klass == null || id == null) {
            return false;
        }
        return this.dirty.containsKey(new Key(klass, id));
    }

    public void storeTransient(IObject iObject) {
        if (iObject == null) {
            return;
        }
        if (iObject.getId() != null) {
            throw new IllegalArgumentException("IObject has id; can't be new.");
        }
        this.created.put(iObject, null);
    }

    public void replaceTransient(IObject iObject, IObject replacement) {
        if (iObject == null) {
            return;
        }
        this.created.put(iObject, replacement);
    }

    public void storePersistent(IObject iObject) {
        if (iObject == null) {
            return;
        }
        this.persistent.put(new Key(iObject), iObject);
    }

    public void storeDirty(IObject iObject) {
        if (iObject == null) {
            return;
        }
        this.dirty.put(new Key(iObject), iObject);
    }

    public void storeDeleted(IObject iObject) {
        if (iObject == null) {
            return;
        }
        this.deleted.put(new Key(iObject), iObject);
    }

    public static class Key {
        Class c;
        Long id;

        private Key() {
        }

        public Key(IObject iObject) {
            if (iObject == null || iObject.getId() == null) {
                throw new IllegalArgumentException("IObject must be in the PERSISTENT state.");
            }
            this.c = iObject.getClass();
            this.id = iObject.getId();
        }

        public Key(Class klass, Long entityId) {
            if (klass == null || entityId == null) {
                throw new IllegalArgumentException("Class and id arguments for Key may not be null.");
            }
            this.c = klass;
            this.id = entityId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return (this.c == other.c || this.c != null && this.c.equals(other.c)) && (this == null ? other.id == null : this.id.equals(other.id));
        }

        public int hashCode() {
            long _id = this.id;
            int result = 11;
            result = result * 17 + this.c.hashCode();
            result = result * 19 + (int)(_id ^ _id >>> 32);
            return result;
        }
    }
}

