/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.RABytes;
import loci.common.RandomAccessStream;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.AWTImageTools;
import loci.formats.ChannelFiller;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.DimensionSwapper;
import loci.formats.FilePattern;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.MinMaxCalculator;
import loci.formats.StatusEvent;
import loci.formats.StatusListener;
import loci.formats.XMLTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;

public final class ImageInfo {
    private ImageInfo() {
    }

    public static boolean testRead(String[] args) throws FormatException, IOException {
        return ImageInfo.testRead(new ImageReader(), args);
    }

    public static boolean testRead(IFormatReader reader, String[] args) throws FormatException, IOException {
        int u;
        String[] used;
        boolean usedValid;
        String id = null;
        boolean pixels = true;
        boolean doMeta = true;
        boolean filter = true;
        boolean thumbs = false;
        boolean minmax = false;
        boolean merge = false;
        boolean stitch = false;
        boolean separate = false;
        boolean expand = false;
        boolean omexml = false;
        boolean normalize = false;
        boolean fastBlit = false;
        boolean preload = false;
        String omexmlVersion = null;
        int start = 0;
        int end = Integer.MAX_VALUE;
        int series = 0;
        int xCoordinate = 0;
        int yCoordinate = 0;
        int width = 0;
        int height = 0;
        String swapOrder = null;
        String shuffleOrder = null;
        String map = null;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-") && args.length > 1) {
                    if (args[i].equals("-nopix")) {
                        pixels = false;
                        continue;
                    }
                    if (args[i].equals("-nometa")) {
                        doMeta = false;
                        continue;
                    }
                    if (args[i].equals("-nofilter")) {
                        filter = false;
                        continue;
                    }
                    if (args[i].equals("-thumbs")) {
                        thumbs = true;
                        continue;
                    }
                    if (args[i].equals("-minmax")) {
                        minmax = true;
                        continue;
                    }
                    if (args[i].equals("-merge")) {
                        merge = true;
                        continue;
                    }
                    if (args[i].equals("-stitch")) {
                        stitch = true;
                        continue;
                    }
                    if (args[i].equals("-separate")) {
                        separate = true;
                        continue;
                    }
                    if (args[i].equals("-expand")) {
                        expand = true;
                        continue;
                    }
                    if (args[i].equals("-omexml")) {
                        omexml = true;
                        continue;
                    }
                    if (args[i].equals("-normalize")) {
                        normalize = true;
                        continue;
                    }
                    if (args[i].equals("-fast")) {
                        fastBlit = true;
                        continue;
                    }
                    if (args[i].equals("-debug")) {
                        FormatHandler.setDebug(true);
                        continue;
                    }
                    if (args[i].equals("-preload")) {
                        preload = true;
                        continue;
                    }
                    if (args[i].equals("-version")) {
                        omexmlVersion = args[++i];
                        continue;
                    }
                    if (args[i].equals("-crop")) {
                        StringTokenizer st = new StringTokenizer(args[++i], ",");
                        xCoordinate = Integer.parseInt(st.nextToken());
                        yCoordinate = Integer.parseInt(st.nextToken());
                        width = Integer.parseInt(st.nextToken());
                        height = Integer.parseInt(st.nextToken());
                        continue;
                    }
                    if (args[i].equals("-level")) {
                        try {
                            FormatHandler.setDebugLevel(Integer.parseInt(args[++i]));
                        }
                        catch (NumberFormatException exc) {}
                        continue;
                    }
                    if (args[i].equals("-range")) {
                        try {
                            start = Integer.parseInt(args[++i]);
                            end = Integer.parseInt(args[++i]);
                        }
                        catch (NumberFormatException exc) {}
                        continue;
                    }
                    if (args[i].equals("-series")) {
                        try {
                            series = Integer.parseInt(args[++i]);
                        }
                        catch (NumberFormatException exc) {}
                        continue;
                    }
                    if (args[i].equals("-swap")) {
                        swapOrder = args[++i].toUpperCase();
                        continue;
                    }
                    if (args[i].equals("-shuffle")) {
                        shuffleOrder = args[++i].toUpperCase();
                        continue;
                    }
                    if (args[i].equals("-map")) {
                        map = args[++i];
                        continue;
                    }
                    LogTools.println("Ignoring unknown command flag: " + args[i]);
                    continue;
                }
                if (id == null) {
                    id = args[i];
                    continue;
                }
                LogTools.println("Ignoring unknown argument: " + args[i]);
            }
        }
        if (FormatHandler.debug) {
            LogTools.println("Debugging at level " + FormatHandler.debugLevel);
        }
        if (id == null) {
            String className = reader.getClass().getName();
            String fmt = reader instanceof ImageReader ? "any" : reader.getFormat();
            String[] s = new String[]{"To test read a file in " + fmt + " format, run:", "  showinf file [-nopix] [-nometa] [-thumbs] [-minmax] ", "    [-merge] [-stitch] [-separate] [-expand] [-omexml]", "    [-normalize] [-fast] [-debug] [-range start end] [-series num]", "    [-swap inputOrder] [-shuffle outputOrder] [-map id] [-preload]", "    [-version v] [-crop x,y,w,h]", "", "      file: the image file to read", "    -nopix: read metadata only, not pixels", "   -nometa: output only core metadata", " -nofilter: do not filter metadata fields", "   -thumbs: read thumbnails instead of normal pixels", "   -minmax: compute min/max statistics", "    -merge: combine separate channels into RGB image", "   -stitch: stitch files with similar names", " -separate: split RGB image into separate channels", "   -expand: expand indexed color to RGB", "   -omexml: populate OME-XML metadata", "-normalize: normalize floating point images*", "     -fast: paint RGB images as quickly as possible*", "    -debug: turn on debugging output", "    -range: specify range of planes to read (inclusive)", "   -series: specify which image series to read", "     -swap: override the default input dimension order", "  -shuffle: override the default output dimension order", "      -map: specify file on disk to which name should be mapped", "  -preload: pre-read entire file into a buffer; significantly", "            reduces the time required to read the images, but", "            requires more memory", "  -version: specify which OME-XML version should be generated", "     -crop: crop images before displaying; argument is 'x,y,w,h'", "", "* = may result in loss of precision", ""};
            for (int i = 0; i < s.length; ++i) {
                LogTools.println(s[i]);
            }
            return false;
        }
        if (map != null) {
            Location.mapId(id, map);
        } else if (preload) {
            RandomAccessStream f = new RandomAccessStream(id);
            byte[] b = new byte[(int)f.length()];
            f.read(b);
            f.close();
            RABytes file = new RABytes(b);
            Location.mapFile(id, file);
        }
        if (omexml) {
            reader.setOriginalMetadataPopulated(true);
            IMetadata store = MetadataTools.createOMEXMLMetadata(null, omexmlVersion);
            if (store != null) {
                reader.setMetadataStore(store);
            }
        }
        if (reader instanceof ImageReader) {
            ImageReader ir = (ImageReader)reader;
            LogTools.print("Checking file format ");
            LogTools.println("[" + ir.getFormat(id) + "]");
        } else {
            LogTools.print("Checking " + reader.getFormat() + " format ");
            LogTools.println(reader.isThisType(id) ? "[yes]" : "[no]");
        }
        LogTools.println("Initializing reader");
        if (stitch) {
            reader = new FileStitcher(reader, true);
            String pat = FilePattern.findPattern(new Location(id));
            if (pat != null) {
                id = pat;
            }
        }
        if (expand) {
            reader = new ChannelFiller(reader);
        }
        if (separate) {
            reader = new ChannelSeparator(reader);
        }
        if (merge) {
            reader = new ChannelMerger(reader);
        }
        MinMaxCalculator minMaxCalc = null;
        if (minmax) {
            minMaxCalc = new MinMaxCalculator(reader);
            reader = minMaxCalc;
        }
        DimensionSwapper dimSwapper = null;
        if (swapOrder != null || shuffleOrder != null) {
            dimSwapper = new DimensionSwapper(reader);
            reader = dimSwapper;
        }
        StatusEchoer status = new StatusEchoer();
        reader.addStatusListener(status);
        reader.close();
        reader.setNormalized(normalize);
        reader.setMetadataFiltered(filter);
        reader.setMetadataCollected(doMeta);
        long s1 = System.currentTimeMillis();
        reader.setId(id);
        long e1 = System.currentTimeMillis();
        float sec1 = (float)(e1 - s1) / 1000.0f;
        LogTools.println("Initialization took " + sec1 + "s");
        if (swapOrder != null) {
            dimSwapper.swapDimensions(swapOrder);
        }
        if (shuffleOrder != null) {
            dimSwapper.setOutputOrder(shuffleOrder);
        }
        if (!(normalize || reader.getPixelType() != 6 && reader.getPixelType() != 7)) {
            LogTools.println("Warning: Java does not support display of unnormalized floating point data.");
            LogTools.println("Please use the '-normalize' option to avoid receiving a cryptic exception.");
        }
        if (reader.isRGB() && reader.getRGBChannelCount() > 4) {
            LogTools.println("Warning: Java does not support merging more than 4 channels.");
            LogTools.println("Please use the '-separate' option to avoid receiving a cryptic exception.");
        }
        LogTools.println();
        LogTools.println("Reading core metadata");
        LogTools.println(stitch ? "File pattern = " + id : "Filename = " + reader.getCurrentFile());
        if (map != null) {
            LogTools.println("Mapped filename = " + map);
        }
        boolean bl = usedValid = (used = reader.getUsedFiles()) != null && used.length > 0;
        if (usedValid) {
            for (u = 0; u < used.length; ++u) {
                if (used[u] != null) continue;
                usedValid = false;
                break;
            }
        }
        if (!usedValid) {
            LogTools.println("************ Warning: invalid used files list ************");
        }
        if (used == null) {
            LogTools.println("Used files = null");
        } else if (used.length == 0) {
            LogTools.println("Used files = []");
        } else if (used.length > 1) {
            LogTools.println("Used files:");
            for (u = 0; u < used.length; ++u) {
                LogTools.println("\t" + used[u]);
            }
        } else if (!id.equals(used[0])) {
            LogTools.println("Used files = [" + used[0] + "]");
        }
        int seriesCount = reader.getSeriesCount();
        LogTools.println("Series count = " + seriesCount);
        MetadataStore ms = reader.getMetadataStore();
        MetadataRetrieve mr = ms instanceof MetadataRetrieve ? (MetadataRetrieve)((Object)ms) : null;
        for (int j = 0; j < seriesCount; ++j) {
            int[] indices;
            int len1;
            int len0;
            reader.setSeries(j);
            int imageCount = reader.getImageCount();
            boolean rgb = reader.isRGB();
            int sizeX = reader.getSizeX();
            int sizeY = reader.getSizeY();
            int sizeZ = reader.getSizeZ();
            int sizeC = reader.getSizeC();
            int sizeT = reader.getSizeT();
            int pixelType = reader.getPixelType();
            int effSizeC = reader.getEffectiveSizeC();
            int rgbChanCount = reader.getRGBChannelCount();
            boolean indexed = reader.isIndexed();
            byte[][] table8 = reader.get8BitLookupTable();
            short[][] table16 = reader.get16BitLookupTable();
            int[] cLengths = reader.getChannelDimLengths();
            String[] cTypes = reader.getChannelDimTypes();
            int thumbSizeX = reader.getThumbSizeX();
            int thumbSizeY = reader.getThumbSizeY();
            boolean little = reader.isLittleEndian();
            String dimOrder = reader.getDimensionOrder();
            boolean orderCertain = reader.isOrderCertain();
            boolean thumbnail = reader.isThumbnailSeries();
            boolean interleaved = reader.isInterleaved();
            boolean metadataComplete = reader.isMetadataComplete();
            String seriesName = mr == null ? null : mr.getImageName(j);
            LogTools.println("Series #" + j + (seriesName == null ? "" : " -- " + seriesName) + ":");
            LogTools.println("\tImage count = " + imageCount);
            LogTools.print("\tRGB = " + rgb + " (" + rgbChanCount + ")");
            if (merge) {
                LogTools.print(" (merged)");
            } else if (separate) {
                LogTools.print(" (separated)");
            }
            LogTools.println();
            if (rgb != (rgbChanCount != 1)) {
                LogTools.println("\t************ Warning: RGB mismatch ************");
            }
            LogTools.println("\tInterleaved = " + interleaved);
            LogTools.print("\tIndexed = " + indexed);
            if (table8 != null) {
                len0 = table8.length;
                len1 = table8[0].length;
                LogTools.print(" (8-bit LUT: " + table8.length + " x ");
                LogTools.print(table8[0] == null ? "null" : "" + table8[0].length);
                LogTools.print(")");
            }
            if (table16 != null) {
                len0 = table16.length;
                len1 = table16[0].length;
                LogTools.print(" (16-bit LUT: " + table16.length + " x ");
                LogTools.print(table16[0] == null ? "null" : "" + table16[0].length);
                LogTools.print(")");
            }
            LogTools.println();
            if (indexed && table8 == null && table16 == null) {
                LogTools.println("\t************ Warning: no LUT ************");
            }
            if (table8 != null && table16 != null) {
                LogTools.println("\t************ Warning: multiple LUTs ************");
            }
            LogTools.println("\tWidth = " + sizeX);
            LogTools.println("\tHeight = " + sizeY);
            LogTools.println("\tSizeZ = " + sizeZ);
            LogTools.println("\tSizeT = " + sizeT);
            LogTools.print("\tSizeC = " + sizeC);
            if (sizeC != effSizeC) {
                LogTools.print(" (effectively " + effSizeC + ")");
            }
            int cProduct = 1;
            if (cLengths.length == 1 && "Channel".equals(cTypes[0])) {
                cProduct = cLengths[0];
            } else {
                LogTools.print(" (");
                for (int i = 0; i < cLengths.length; ++i) {
                    if (i > 0) {
                        LogTools.print(" x ");
                    }
                    LogTools.print(cLengths[i] + " " + cTypes[i]);
                    cProduct *= cLengths[i];
                }
                LogTools.print(")");
            }
            LogTools.println();
            if (cLengths.length == 0 || cProduct != sizeC) {
                LogTools.println("\t************ Warning: C dimension mismatch ************");
            }
            if (imageCount != sizeZ * effSizeC * sizeT) {
                LogTools.println("\t************ Warning: ZCT mismatch ************");
            }
            LogTools.println("\tThumbnail size = " + thumbSizeX + " x " + thumbSizeY);
            LogTools.println("\tEndianness = " + (little ? "intel (little)" : "motorola (big)"));
            LogTools.println("\tDimension order = " + dimOrder + (orderCertain ? " (certain)" : " (uncertain)"));
            LogTools.println("\tPixel type = " + FormatTools.getPixelTypeString(pixelType));
            LogTools.println("\tMetadata complete = " + metadataComplete);
            LogTools.println("\tThumbnail series = " + thumbnail);
            if (!doMeta) continue;
            LogTools.println("\t-----");
            if (imageCount > 6) {
                int q = imageCount / 2;
                indices = new int[]{0, q - 2, q - 1, q, q + 1, q + 2, imageCount - 1};
            } else {
                indices = imageCount > 2 ? new int[]{0, imageCount / 2, imageCount - 1} : (imageCount > 1 ? new int[]{0, 1} : new int[]{0});
            }
            int[][] zct = new int[indices.length][];
            int[] indices2 = new int[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                zct[i] = reader.getZCTCoords(indices[i]);
                indices2[i] = reader.getIndex(zct[i][0], zct[i][1], zct[i][2]);
                LogTools.print("\tPlane #" + indices[i] + " <=> Z " + zct[i][0] + ", C " + zct[i][1] + ", T " + zct[i][2]);
                if (indices[i] != indices2[i]) {
                    LogTools.println(" [mismatch: " + indices2[i] + "]");
                    continue;
                }
                LogTools.println();
            }
        }
        reader.setSeries(series);
        String s = seriesCount > 1 ? " series #" + series : "";
        int pixelType = reader.getPixelType();
        int sizeC = reader.getSizeC();
        Double[] preGlobalMin = null;
        Double[] preGlobalMax = null;
        Double[] preKnownMin = null;
        Double[] preKnownMax = null;
        Double[] prePlaneMin = null;
        Double[] prePlaneMax = null;
        boolean preIsMinMaxPop = false;
        if (minmax) {
            preGlobalMin = new Double[sizeC];
            preGlobalMax = new Double[sizeC];
            preKnownMin = new Double[sizeC];
            preKnownMax = new Double[sizeC];
            for (int c = 0; c < sizeC; ++c) {
                preGlobalMin[c] = minMaxCalc.getChannelGlobalMinimum(c);
                preGlobalMax[c] = minMaxCalc.getChannelGlobalMaximum(c);
                preKnownMin[c] = minMaxCalc.getChannelKnownMinimum(c);
                preKnownMax[c] = minMaxCalc.getChannelKnownMaximum(c);
            }
            prePlaneMin = minMaxCalc.getPlaneMinimum(0);
            prePlaneMax = minMaxCalc.getPlaneMaximum(0);
            preIsMinMaxPop = minMaxCalc.isMinMaxPopulated();
        }
        if (pixels) {
            LogTools.println();
            LogTools.print("Reading" + s + " pixel data ");
            status.setVerbose(false);
            int num = reader.getImageCount();
            if (start < 0) {
                start = 0;
            }
            if (start >= num) {
                start = num - 1;
            }
            if (end < 0) {
                end = 0;
            }
            if (end >= num) {
                end = num - 1;
            }
            if (end < start) {
                end = start;
            }
            if (width == 0) {
                width = reader.getSizeX();
            }
            if (height == 0) {
                height = reader.getSizeY();
            }
            LogTools.print("(" + start + "-" + end + ") ");
            BufferedImage[] images = new BufferedImage[end - start + 1];
            long s2 = System.currentTimeMillis();
            boolean mismatch = false;
            for (int i = start; i <= end; ++i) {
                status.setEchoNext(true);
                if (!fastBlit) {
                    images[i - start] = thumbs ? reader.openThumbImage(i) : reader.openImage(i, xCoordinate, yCoordinate, width, height);
                } else {
                    int x = reader.getSizeX();
                    int y = reader.getSizeY();
                    byte[] b = thumbs ? reader.openThumbBytes(i) : reader.openBytes(i, xCoordinate, yCoordinate, width, height);
                    Object pix = DataTools.makeDataArray(b, FormatTools.getBytesPerPixel(pixelType), FormatTools.isFloatingPoint(pixelType), reader.isLittleEndian());
                    images[i - start] = AWTImageTools.makeImage(ImageTools.make24Bits(pix, x, y, false, false), x, y, FormatTools.isSigned(pixelType));
                }
                int pixType = AWTImageTools.getPixelType(images[i - start]);
                if (pixType != pixelType && pixType != pixelType + 1 && !fastBlit) {
                    if (!mismatch) {
                        LogTools.println();
                        mismatch = true;
                    }
                    LogTools.println("\tPlane #" + i + ": pixel type mismatch: " + FormatTools.getPixelTypeString(pixType) + "/" + FormatTools.getPixelTypeString(pixelType));
                    continue;
                }
                mismatch = false;
                LogTools.print(".");
            }
            long e2 = System.currentTimeMillis();
            if (!mismatch) {
                LogTools.print(" ");
            }
            LogTools.println("[done]");
            float sec2 = (float)(e2 - s2) / 1000.0f;
            float avg = (float)(e2 - s2) / (float)images.length;
            LogTools.println(sec2 + "s elapsed (" + avg + "ms per image)");
            if (minmax) {
                int subC;
                Double[] globalMin = new Double[sizeC];
                Double[] globalMax = new Double[sizeC];
                Double[] knownMin = new Double[sizeC];
                Double[] knownMax = new Double[sizeC];
                for (int c = 0; c < sizeC; ++c) {
                    globalMin[c] = minMaxCalc.getChannelGlobalMinimum(c);
                    globalMax[c] = minMaxCalc.getChannelGlobalMaximum(c);
                    knownMin[c] = minMaxCalc.getChannelKnownMinimum(c);
                    knownMax[c] = minMaxCalc.getChannelKnownMaximum(c);
                }
                Double[] planeMin = minMaxCalc.getPlaneMinimum(0);
                Double[] planeMax = minMaxCalc.getPlaneMaximum(0);
                boolean isMinMaxPop = minMaxCalc.isMinMaxPopulated();
                LogTools.println();
                LogTools.println("Min/max values:");
                for (int c = 0; c < sizeC; ++c) {
                    LogTools.println("\tChannel " + c + ":");
                    LogTools.println("\t\tGlobal minimum = " + globalMin[c] + " (initially " + preGlobalMin[c] + ")");
                    LogTools.println("\t\tGlobal maximum = " + globalMax[c] + " (initially " + preGlobalMax[c] + ")");
                    LogTools.println("\t\tKnown minimum = " + knownMin[c] + " (initially " + preKnownMin[c] + ")");
                    LogTools.println("\t\tKnown maximum = " + knownMax[c] + " (initially " + preKnownMax[c] + ")");
                }
                LogTools.print("\tFirst plane minimum(s) =");
                if (planeMin == null) {
                    LogTools.print(" none");
                } else {
                    for (subC = 0; subC < planeMin.length; ++subC) {
                        LogTools.print(" " + planeMin[subC]);
                    }
                }
                LogTools.print(" (initially");
                if (prePlaneMin == null) {
                    LogTools.print(" none");
                } else {
                    for (subC = 0; subC < prePlaneMin.length; ++subC) {
                        LogTools.print(" " + prePlaneMin[subC]);
                    }
                }
                LogTools.println(")");
                LogTools.print("\tFirst plane maximum(s) =");
                if (planeMax == null) {
                    LogTools.print(" none");
                } else {
                    for (subC = 0; subC < planeMax.length; ++subC) {
                        LogTools.print(" " + planeMax[subC]);
                    }
                }
                LogTools.print(" (initially");
                if (prePlaneMax == null) {
                    LogTools.print(" none");
                } else {
                    for (subC = 0; subC < prePlaneMax.length; ++subC) {
                        LogTools.print(" " + prePlaneMax[subC]);
                    }
                }
                LogTools.println(")");
                LogTools.println("\tMin/max populated = " + isMinMaxPop + " (initially " + preIsMinMaxPop + ")");
            }
            LogTools.println();
            LogTools.println("Launching image viewer");
            ReflectedUniverse r = new ReflectedUniverse();
            try {
                r.exec("import loci.formats.gui.ImageViewer");
                r.exec("viewer = new ImageViewer()");
                r.setVar("reader", reader);
                r.setVar("images", images);
                r.setVar("true", true);
                r.exec("viewer.setImages(reader, images)");
                r.exec("viewer.setVisible(true)");
            }
            catch (ReflectException exc) {
                throw new FormatException(exc);
            }
        }
        if (doMeta) {
            LogTools.println();
            LogTools.println("Reading" + s + " metadata");
            Hashtable meta = reader.getMetadata();
            Object[] keys = meta.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                LogTools.print((String)keys[i] + ": ");
                LogTools.println(reader.getMetadataValue((String)keys[i]));
            }
        }
        if (omexml) {
            LogTools.println();
            String version = MetadataTools.getOMEXMLVersion(ms);
            if (version == null) {
                LogTools.println("Generating OME-XML");
            } else {
                LogTools.println("Generating OME-XML (schema version " + version + ")");
            }
            if (MetadataTools.isOMEXMLMetadata(ms)) {
                String xml = MetadataTools.getOMEXML((MetadataRetrieve)((Object)ms));
                LogTools.println(XMLTools.indentXML(xml));
                MetadataTools.validateOMEXML(xml);
            } else {
                LogTools.println("The metadata could not be converted to OME-XML.");
                if (omexmlVersion == null) {
                    LogTools.println("The OME-XML Java library is probably not available.");
                } else {
                    LogTools.println(omexmlVersion + " is probably not a legal schema version.");
                }
            }
        }
        return true;
    }

    public static void main(String[] args) throws FormatException, IOException {
        if (!ImageInfo.testRead(args)) {
            System.exit(1);
        }
    }

    private static class StatusEchoer
    implements StatusListener {
        private boolean verbose = true;
        private boolean next = true;

        private StatusEchoer() {
        }

        public void setVerbose(boolean value) {
            this.verbose = value;
        }

        public void setEchoNext(boolean value) {
            this.next = value;
        }

        public void statusUpdated(StatusEvent e) {
            if (this.verbose) {
                LogTools.println("\t" + e.getStatusMessage());
            } else if (this.next) {
                LogTools.print(";");
                this.next = false;
            }
        }
    }
}

