/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.RandomAccessFile;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatWriter;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.meta.MetadataRetrieve;

public class JPEG2000Writer
extends FormatWriter {
    private RandomAccessFile out;

    public JPEG2000Writer() {
        super("JPEG-2000", "jp2");
    }

    public void saveImage(Image image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        if (image == null) {
            throw new FormatException("Image is null");
        }
        BufferedImage img = AWTImageTools.makeBuffered(image, this.cm);
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        boolean littleEndian = retrieve.getPixelsBigEndian(0, 0) == false;
        byte[][] byteData = AWTImageTools.getPixelBytes(img, littleEndian);
        byte[] stream = new byte[byteData.length * byteData[0].length];
        int next = 0;
        int rowLen = byteData[0].length / img.getHeight();
        int bpp = rowLen / img.getWidth();
        for (int row = 0; row < img.getHeight(); ++row) {
            for (int col = 0; col < img.getWidth(); ++col) {
                for (int c = 0; c < byteData.length; ++c) {
                    System.arraycopy(byteData[c], row * rowLen + col * bpp, stream, next, bpp);
                    next += bpp;
                }
            }
        }
        int bytesPerPixel = byteData[0].length / (img.getWidth() * img.getHeight());
        this.out = new RandomAccessFile(this.currentId, "rw");
        CodecOptions options = new CodecOptions();
        options.width = img.getWidth();
        options.height = img.getHeight();
        options.channels = img.getRaster().getNumBands();
        options.bitsPerSample = bytesPerPixel * 8;
        options.littleEndian = littleEndian;
        options.interleaved = true;
        byte[] compressedData = new JPEG2000Codec().compress(stream, options);
        this.out.write(compressedData);
        this.out.close();
    }

    public boolean canDoStacks() {
        return false;
    }

    public int[] getPixelTypes() {
        return new int[]{0, 1, 2, 3};
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
    }
}

