/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import loci.common.DataTools;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;

public class APNGWriter
extends FormatWriter {
    private static final byte[] PNG_SIG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private RandomAccessFile out;
    private int numFrames = 0;
    private long numFramesPointer = 0L;
    private int nextSequenceNumber;

    public APNGWriter() {
        super("Animated PNG", "png");
    }

    public void saveImage(Image image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        if (image == null) {
            throw new FormatException("Image is null");
        }
        BufferedImage img = AWTImageTools.makeBuffered(image, this.cm);
        byte[][] byteData = AWTImageTools.getPixelBytes(img, false);
        byte[] stream = new byte[byteData.length * byteData[0].length + img.getHeight()];
        int next = 0;
        int rowLen = byteData[0].length / img.getHeight();
        int bpp = rowLen / img.getWidth();
        for (int row = 0; row < img.getHeight(); ++row) {
            stream[next++] = 0;
            for (int col = 0; col < img.getWidth(); ++col) {
                for (int c = 0; c < byteData.length; ++c) {
                    System.arraycopy(byteData[c], row * rowLen + col * bpp, stream, next, bpp);
                    next += bpp;
                }
            }
        }
        int bytesPerPixel = FormatTools.getBytesPerPixel(AWTImageTools.getPixelType(img));
        if (!this.initialized) {
            this.out = new RandomAccessFile(this.currentId, "rw");
            this.out.write(PNG_SIG);
            this.out.writeInt(13);
            byte[] buf = new byte[17];
            buf[0] = 73;
            buf[1] = 72;
            buf[2] = 68;
            buf[3] = 82;
            DataTools.unpackBytes(img.getWidth(), buf, 4, 4, false);
            DataTools.unpackBytes(img.getHeight(), buf, 8, 4, false);
            buf[12] = (byte)(bytesPerPixel * 8);
            if (byteData.length == 1) {
                buf[13] = 0;
            } else if (byteData.length == 2) {
                buf[13] = 4;
            } else if (byteData.length == 3) {
                buf[13] = 2;
            } else if (byteData.length == 4) {
                buf[13] = 6;
            }
            buf[14] = 0;
            buf[15] = 0;
            buf[16] = 0;
            this.out.write(buf);
            this.out.writeInt(this.crc(buf));
            this.out.writeInt(8);
            this.out.writeBytes("acTL");
            this.numFramesPointer = this.out.getFilePointer();
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.writeFCTL(img.getWidth(), img.getHeight());
            this.writePixels("IDAT", stream);
            this.initialized = true;
        } else {
            this.writeFCTL(img.getWidth(), img.getHeight());
            this.writePixels("fdAT", stream);
        }
        ++this.numFrames;
        if (last) {
            this.out.writeInt(0);
            this.out.writeBytes("IEND");
            this.out.writeInt(this.crc("IEND".getBytes()));
            this.out.seek(this.numFramesPointer);
            this.out.writeInt(this.numFrames);
            this.out.skipBytes(4);
            byte[] b = new byte[12];
            b[0] = 97;
            b[1] = 99;
            b[2] = 84;
            b[3] = 76;
            DataTools.unpackBytes(this.numFrames, b, 4, 4, false);
            DataTools.unpackBytes(0L, b, 8, 4, false);
            this.out.writeInt(this.crc(b));
        }
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes() {
        return new int[]{0, 1, 2, 3};
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
        this.numFrames = 0;
    }

    private int crc(byte[] buf) {
        return this.crc(buf, 0, buf.length);
    }

    private int crc(byte[] buf, int off, int len) {
        CRC32 crc = new CRC32();
        crc.update(buf, off, len);
        return (int)crc.getValue();
    }

    private void writeFCTL(int width, int height) throws IOException {
        this.out.writeInt(26);
        byte[] b = new byte[30];
        b[0] = 102;
        b[1] = 99;
        b[2] = 84;
        b[3] = 76;
        DataTools.unpackBytes(this.nextSequenceNumber++, b, 4, 4, false);
        DataTools.unpackBytes(width, b, 8, 4, false);
        DataTools.unpackBytes(height, b, 12, 4, false);
        DataTools.unpackBytes(0L, b, 16, 4, false);
        DataTools.unpackBytes(0L, b, 20, 4, false);
        DataTools.unpackBytes(1L, b, 24, 2, false);
        DataTools.unpackBytes(this.fps, b, 26, 2, false);
        b[28] = 1;
        b[29] = 0;
        this.out.write(b);
        this.out.writeInt(this.crc(b));
    }

    private void writePixels(String chunk, byte[] stream) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setInput(stream);
        deflater.finish();
        int extra = chunk.equals("fdAT") ? 4 : 0;
        byte[] tmp = new byte[stream.length + 4 + extra];
        byte[] chunkBytes = chunk.getBytes();
        System.arraycopy(chunkBytes, 0, tmp, 0, 4);
        if (chunk.equals("fdAT")) {
            DataTools.unpackBytes(this.nextSequenceNumber++, tmp, 4, 4, false);
        }
        int nBytes = deflater.deflate(tmp, extra + 4, stream.length);
        this.out.writeInt(nBytes + extra);
        this.out.write(tmp, 0, nBytes + extra + 4);
        this.out.writeInt(this.crc(tmp, 0, nBytes + extra + 4));
    }
}

