/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.ome;

import java.io.ByteArrayOutputStream;
import javax.xml.transform.TransformerException;
import loci.common.LogTools;
import loci.formats.meta.IMetadata;
import ome.xml.DOMUtil;
import ome.xml.OMEXMLNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class OMEXMLMetadata
implements IMetadata {
    private static final String ORIGINAL_METADATA = "OriginalMetadata";
    protected OMEXMLNode root;
    private Element imageCA;
    private boolean omCreated;

    public String dumpXML() {
        if (this.root == null) {
            return null;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DOMUtil.writeXML(os, this.root.getDOMElement().getOwnerDocument());
            return os.toString();
        }
        catch (TransformerException exc) {
            LogTools.trace(exc);
            return null;
        }
    }

    public void setOriginalMetadata(String key, String value) {
        if (this.imageCA == null) {
            Element ome = this.root.getDOMElement();
            Element image = DOMUtil.getChildElement("Image", ome);
            if (image == null) {
                this.setImageName("", 0);
                image = DOMUtil.getChildElement("Image", ome);
            }
            this.imageCA = DOMUtil.getChildElement("CustomAttributes", image);
            if (this.imageCA == null) {
                this.imageCA = DOMUtil.createChild(image, "CustomAttributes", true);
            }
        }
        if (!this.omCreated) {
            Element std = DOMUtil.createChild(this.root.getDOMElement(), "SemanticTypeDefinitions");
            DOMUtil.setAttribute("xmlns", "http://www.openmicroscopy.org/XMLschemas/STD/RC2/STD.xsd", std);
            Element st = DOMUtil.createChild(std, "SemanticType");
            DOMUtil.setAttribute("Name", ORIGINAL_METADATA, st);
            DOMUtil.setAttribute("AppliesTo", "I", st);
            Element nameElement = DOMUtil.createChild(st, "Element");
            DOMUtil.setAttribute("Name", "Name", nameElement);
            DOMUtil.setAttribute("DBLocation", "ORIGINAL_METADATA.NAME", nameElement);
            DOMUtil.setAttribute("DataType", "string", nameElement);
            Element valueElement = DOMUtil.createChild(st, "Element");
            DOMUtil.setAttribute("Name", "Value", valueElement);
            DOMUtil.setAttribute("DBLocation", "ORIGINAL_METADATA.VALUE", valueElement);
            DOMUtil.setAttribute("DataType", "string", valueElement);
            this.omCreated = true;
        }
        Element om = DOMUtil.createChild(this.imageCA, ORIGINAL_METADATA);
        DOMUtil.setAttribute("ID", this.root.makeID(ORIGINAL_METADATA), om);
        DOMUtil.setAttribute("Name", key, om);
        DOMUtil.setAttribute("Value", value, om);
    }

    public String getOriginalMetadataValue(String key) {
        if (this.imageCA == null) {
            Element ome = this.root.getDOMElement();
            Element image = DOMUtil.getChildElement("Image", ome);
            if (image == null) {
                return null;
            }
            this.imageCA = DOMUtil.getChildElement("CustomAttributes", image);
            if (this.imageCA == null) {
                return null;
            }
        }
        NodeList list = this.imageCA.getChildNodes();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            String nodeName;
            Node node = list.item(i);
            if (!(node instanceof Element) || !(nodeName = node.getNodeName()).equals(ORIGINAL_METADATA)) continue;
            NamedNodeMap attrs = node.getAttributes();
            int len = attrs.getLength();
            String value = null;
            for (int j = 0; j < len; ++j) {
                Attr attr = (Attr)attrs.item(i);
                if (attr == null) continue;
                String attrName = attr.getName();
                if ("Name".equals(attrName)) {
                    String name = attr.getValue();
                    if (key.equals(name)) continue;
                    value = null;
                    break;
                }
                if (!"Value".equals(attrName)) continue;
                value = attr.getValue();
            }
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public String getUUID() {
        Element ome = this.root.getDOMElement();
        return DOMUtil.getAttribute("UUID", ome);
    }

    public Object getRoot() {
        return this.root;
    }

    public void setUUID(String uuid) {
        Element ome = this.root.getDOMElement();
        DOMUtil.setAttribute("UUID", uuid, ome);
    }

    protected Integer booleanToInteger(Boolean value) {
        return value == null ? null : new Integer(value != false ? 2 : 1);
    }

    protected Boolean integerToBoolean(Integer value) {
        return value == null ? null : new Boolean(value == 2);
    }

    protected Integer floatToInteger(Float value) {
        return value == null ? null : new Integer(value.intValue());
    }

    protected Float integerToFloat(Integer value) {
        return value == null ? null : new Float(value.floatValue());
    }
}

