/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.RandomAccessStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class VisitechReader
extends FormatReader {
    public static final String[] HTML_SUFFIX = new String[]{"html"};
    private Vector files;

    public VisitechReader() {
        super("Visitech XYS", new String[]{"xys", "html"});
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int plane = this.getSizeX() * this.getSizeY() * bpp;
        int div = this.getSizeZ() * this.getSizeT();
        int fileIndex = this.series * this.getSizeC() + no / div;
        int planeIndex = no % div;
        String file = (String)this.files.get(fileIndex);
        RandomAccessStream s = new RandomAccessStream(file);
        s.seek(374L);
        while (s.read() != -16) {
        }
        s.skipBytes(1);
        if (s.readInt() == 0) {
            s.skipBytes(4 + (plane + 164) * planeIndex);
        } else if (planeIndex == 0) {
            s.seek(s.getFilePointer() - 4L);
        } else {
            s.skipBytes((plane + 164) * planeIndex - 4);
        }
        this.readPlane(s, x, y, w, h, buf);
        s.close();
        return buf;
    }

    public String[] getUsedFiles() {
        if (this.files == null) {
            return new String[0];
        }
        return this.files.toArray(new String[0]);
    }

    public void close() throws IOException {
        super.close();
        this.files = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        String file;
        int ndx;
        super.initFile(id);
        if (!VisitechReader.checkSuffix(id, HTML_SUFFIX)) {
            String base = id.substring(0, id.lastIndexOf(" "));
            this.currentId = null;
            this.initFile(base + " Report.html");
            return;
        }
        this.in = new RandomAccessStream(id);
        String s = this.in.readString((int)this.in.length());
        s = s.replaceAll("<[bB][rR]>", "\n");
        s = s.replaceAll("<[sS][tT][yY][lL][eE]\\p{ASCII}*?[sS][tT][yY][lL][eE]>", "");
        s = s.replaceAll("<[sS][cC][rR][iI][pP][tT]\\p{ASCII}*?[sS][cC][rR][iI][pP][tT]>", "");
        StringTokenizer st = new StringTokenizer(s, "\n");
        String token = null;
        String key = null;
        String value = null;
        int numSeries = 0;
        while (st.hasMoreTokens()) {
            token = st.nextToken().trim();
            if ((!token.startsWith("<") || token.startsWith("</")) && token.indexOf("pixels") == -1) continue;
            ndx = (token = token.replaceAll("<.*?>", "")).indexOf(":");
            if (ndx != -1) {
                key = token.substring(0, ndx).trim();
                value = token.substring(ndx + 1).trim();
                if (key.equals("Number of steps")) {
                    this.core[0].sizeZ = Integer.parseInt(value);
                } else if (key.equals("Image bit depth")) {
                    int bits = Integer.parseInt(value);
                    while (bits % 8 != 0) {
                        ++bits;
                    }
                    switch (bits) {
                        case 16: {
                            this.core[0].pixelType = 3;
                            break;
                        }
                        case 32: {
                            this.core[0].pixelType = 5;
                            break;
                        }
                        default: {
                            this.core[0].pixelType = 1;
                            break;
                        }
                    }
                } else if (key.equals("Image dimensions")) {
                    int n = value.indexOf(",");
                    this.core[0].sizeX = Integer.parseInt(value.substring(1, n).trim());
                    this.core[0].sizeY = Integer.parseInt(value.substring(n + 1, value.length() - 1).trim());
                } else if (key.startsWith("Channel Selection")) {
                    ++this.core[0].sizeC;
                } else if (key.startsWith("Microscope XY")) {
                    ++numSeries;
                }
                this.addMeta(key, value);
            }
            if (token.indexOf("pixels") != -1) {
                ++this.core[0].sizeC;
                this.core[0].imageCount += Integer.parseInt(token.substring(0, token.indexOf(" ")));
                continue;
            }
            if (!token.startsWith("Time Series")) continue;
            int idx = token.indexOf(";") + 1;
            String ss = token.substring(idx, token.indexOf(" ", idx)).trim();
            this.core[0].sizeT = Integer.parseInt(ss);
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
            if (this.getSizeT() == 0) {
                this.core[0].sizeT = 1;
            }
        }
        if (this.getImageCount() == 0) {
            this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        }
        if (numSeries > 1) {
            int x = this.getSizeX();
            int y = this.getSizeY();
            int z = this.getSizeZ();
            int c = this.getSizeC() / numSeries;
            int t = this.getSizeT();
            int count = z * c * t;
            int ptype = this.getPixelType();
            this.core = new CoreMetadata[numSeries];
            for (int i = 0; i < numSeries; ++i) {
                this.core[i] = new CoreMetadata();
                this.core[i].sizeX = x;
                this.core[i].sizeY = y;
                this.core[i].sizeZ = z;
                this.core[i].sizeC = c;
                this.core[i].sizeT = t;
                this.core[i].imageCount = count;
                this.core[i].pixelType = ptype;
            }
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.core[i].rgb = false;
            this.core[i].dimensionOrder = "XYZTC";
            this.core[i].interleaved = false;
            this.core[i].littleEndian = true;
            this.core[i].indexed = false;
            this.core[i].falseColor = false;
            this.core[i].metadataComplete = true;
        }
        this.files = new Vector();
        ndx = this.currentId.lastIndexOf(File.separator) + 1;
        String base = this.currentId.substring(ndx, this.currentId.lastIndexOf(" "));
        File f = new File(this.currentId).getAbsoluteFile();
        String string = file = f.exists() ? f.getParent() + File.separator : "";
        if (numSeries == 0) {
            numSeries = 1;
        }
        for (int i = 0; i < this.getSizeC() * numSeries; ++i) {
            this.files.add(file + base + " " + (i + 1) + ".xys");
        }
        this.files.add(this.currentId);
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        for (int i = 0; i < numSeries; ++i) {
            store.setImageName("Position " + i, i);
            MetadataTools.setDefaultCreationDate(store, id, i);
        }
    }
}

