/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import loci.common.DataTools;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class PGMReader
extends FormatReader {
    private boolean rawBits;
    private long offset;

    public PGMReader() {
        super("Portable Gray Map", "pgm");
        this.blockCheckLen = 1;
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        return stream.read() == 80;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        this.in.seek(this.offset);
        if (this.rawBits) {
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            int pt = 0;
            block0: while (true) {
                String line = this.in.readLine().trim();
                line = line.replaceAll("[^0-9]", " ");
                StringTokenizer t = new StringTokenizer(line, " ");
                while (true) {
                    if (!t.hasMoreTokens()) continue block0;
                    int q = Integer.parseInt(t.nextToken().trim());
                    if (this.getPixelType() == 3) {
                        DataTools.unpackShort((short)q, buf, pt, this.isLittleEndian());
                        pt += 2;
                        continue;
                    }
                    buf[pt++] = (byte)q;
                }
                break;
            }
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.rawBits = false;
        this.offset = 0L;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        String magic = this.in.readLine().trim();
        boolean isBlackAndWhite = false;
        this.rawBits = magic.equals("P4") || magic.equals("P5") || magic.equals("P6");
        this.core[0].sizeC = magic.equals("P3") || magic.equals("P6") ? 3 : 1;
        isBlackAndWhite = magic.equals("P1") || magic.equals("P4");
        String line = this.in.readLine().trim();
        while (line.startsWith("#") || line.length() == 0) {
            line = this.in.readLine();
        }
        line = line.replaceAll("[^0-9]", " ");
        this.core[0].sizeX = Integer.parseInt(line.substring(0, line.indexOf(" ")).trim());
        this.core[0].sizeY = Integer.parseInt(line.substring(line.indexOf(" ") + 1).trim());
        if (!isBlackAndWhite) {
            int max = Integer.parseInt(this.in.readLine().trim());
            this.core[0].pixelType = max > 255 ? 3 : 1;
        }
        this.offset = this.in.getFilePointer();
        this.core[0].rgb = this.getSizeC() == 3;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].littleEndian = true;
        this.core[0].interleaved = false;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

