/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.Location;
import loci.common.RandomAccessStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;

public class L2DReader
extends FormatReader {
    private Vector[] tiffs;
    private Vector used;
    private MinimalTiffReader reader;

    public L2DReader() {
        super("Li-Cor L2D", new String[]{"l2d", "scn"});
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        this.reader.setId((String)this.tiffs[this.series].get(no));
        return this.reader.openBytes(0, buf, x, y, w, h);
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.used.toArray(new String[0]);
    }

    public void close() throws IOException {
        super.close();
        this.tiffs = null;
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = null;
        this.used = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        if (debug) {
            this.debug("L2DReader.initFile(" + id + ")");
        }
        if (id.toLowerCase().endsWith(".scn")) {
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            String[] list = parent.list();
            for (int i2 = 0; i2 < list.length; ++i2) {
                if (!list[i2].toLowerCase().endsWith(".l2d")) continue;
                this.initFile(new Location(parent.getAbsolutePath(), list[i2]).getAbsolutePath());
                break;
            }
            return;
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.used = new Vector();
        this.used.add(new Location(id).getAbsolutePath());
        Location parent = new Location(id).getAbsoluteFile().getParentFile();
        Vector<String> scans = new Vector<String>();
        String line = this.in.readLine().trim();
        while (line != null && line.length() > 0) {
            if (!line.startsWith("#")) {
                String key = line.substring(0, line.indexOf("="));
                String value = line.substring(line.indexOf("=") + 1);
                this.addMeta(key, value);
                if (key.equals("ScanNames")) {
                    StringTokenizer names = new StringTokenizer(value, ",");
                    while (names.hasMoreTokens()) {
                        scans.add(names.nextToken().trim());
                    }
                }
            }
            line = this.in.readLine().trim();
        }
        this.in.close();
        this.tiffs = new Vector[scans.size()];
        this.core = new CoreMetadata[scans.size()];
        for (int i3 = 0; i3 < scans.size(); ++i3) {
            this.core[i3] = new CoreMetadata();
            this.tiffs[i3] = new Vector();
            String scanName = (String)scans.get(i3);
            Location scanDir = new Location(parent, scanName);
            String scanPath = new Location(scanDir, scanName + ".scn").getAbsolutePath();
            this.addDirectory(scanDir.getAbsolutePath());
            RandomAccessStream scan = new RandomAccessStream(scanPath);
            line = scan.readLine().trim();
            while (line != null && line.length() > 0) {
                if (!line.startsWith("#")) {
                    String key = line.substring(0, line.indexOf("="));
                    String value = line.substring(line.indexOf("=") + 1);
                    this.addMeta(scanName + " " + key, value);
                    if (!key.equals("ExperimentNames") && key.equals("ImageNames")) {
                        StringTokenizer names = new StringTokenizer(value, ",");
                        while (names.hasMoreTokens()) {
                            String path = names.nextToken().trim();
                            String tiff = new Location(scanDir, path).getAbsolutePath();
                            this.tiffs[i3].add(tiff);
                        }
                    }
                }
                line = scan.readLine().trim();
            }
        }
        this.reader = new MinimalTiffReader();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        for (i = 0; i < scans.size(); ++i) {
            this.core[i].imageCount = this.tiffs[i].size();
            this.core[i].sizeC = this.tiffs[i].size();
            this.core[i].sizeT = 1;
            this.core[i].sizeZ = 1;
            this.core[i].dimensionOrder = "XYCZT";
            for (int t = 0; t < this.tiffs[i].size(); ++t) {
                this.reader.setId((String)this.tiffs[i].get(t));
                if (t != 0) continue;
                this.core[i].sizeX = this.reader.getSizeX();
                this.core[i].sizeY = this.reader.getSizeY();
                this.core[i].sizeC *= this.reader.getSizeC();
                this.core[i].rgb = this.reader.isRGB();
                this.core[i].indexed = this.reader.isIndexed();
                this.core[i].littleEndian = this.reader.isLittleEndian();
                this.core[i].pixelType = this.reader.getPixelType();
            }
        }
        MetadataTools.populatePixels(store, this);
        for (i = 0; i < scans.size(); ++i) {
            store.setImageName("", i);
            MetadataTools.setDefaultCreationDate(store, id, i);
        }
    }

    private void addDirectory(String path) {
        Location dir = new Location(path);
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            Location file = new Location(path, files[i]);
            if (file.isDirectory()) {
                this.addDirectory(file.getAbsolutePath());
                continue;
            }
            String check = files[i].toLowerCase();
            if (!check.endsWith(".tif") && !check.endsWith(".data") && !check.endsWith(".log") && !check.endsWith(".scn")) continue;
            this.used.add(file.getAbsolutePath());
        }
    }
}

