/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import loci.common.RandomAccessStream;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public abstract class ImageIOReader
extends FormatReader {
    public ImageIOReader(String name, String suffix) {
        super(name, suffix);
    }

    public ImageIOReader(String name, String[] suffixes) {
        super(name, suffixes);
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        byte[] t = AWTImageTools.getBytes(this.openImage(no, x, y, w, h), false);
        System.arraycopy(t, 0, buf, 0, Math.min(t.length, buf.length));
        return buf;
    }

    public BufferedImage openImage(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        RandomAccessStream ras = new RandomAccessStream(this.currentId);
        DataInputStream dis = new DataInputStream(new BufferedInputStream(ras, 4096));
        BufferedImage b = ImageIO.read(dis);
        ras.close();
        dis.close();
        return b.getSubimage(x, y, w, h);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("ImageIOReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.status("Populating metadata");
        this.core[0].imageCount = 1;
        BufferedImage img = ImageIO.read(new DataInputStream(new RandomAccessStream(this.currentId)));
        this.core[0].sizeX = img.getWidth();
        this.core[0].sizeY = img.getHeight();
        this.core[0].rgb = img.getRaster().getNumBands() > 1;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = this.isRGB() ? 3 : 1;
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].pixelType = AWTImageTools.getPixelType(img);
        this.core[0].interleaved = false;
        this.core[0].littleEndian = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

