/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.IMinMaxStore;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class BioRadReader
extends FormatReader {
    private static final int PIC_FILE_ID = 12345;
    private static final boolean LITTLE_ENDIAN = true;
    private static final String[] MERGE_NAMES = new String[]{"MERGE_OFF", "MERGE_16", "MERGE_ALTERNATE", "MERGE_COLUMN", "MERGE_ROW", "MERGE_MAXIMUM", "MERGE_OPT12", "MERGE_OPT12_V2"};
    public static final String[] NOTE_NAMES = new String[]{"0", "LIVE", "FILE1", "NUMBER", "USER", "LINE", "COLLECT", "FILE2", "SCALEBAR", "MERGE", "THRUVIEW", "ARROW", "12", "13", "14", "15", "16", "17", "18", "19", "VARIABLE", "STRUCTURE", "4D SERIES"};
    public static final int NOTE_TYPE_LIVE = 1;
    public static final int NOTE_TYPE_FILE1 = 2;
    public static final int NOTE_TYPE_NUMBER = 3;
    public static final int NOTE_TYPE_USER = 4;
    public static final int NOTE_TYPE_LINE = 5;
    public static final int NOTE_TYPE_COLLECT = 6;
    public static final int NOTE_TYPE_FILE2 = 7;
    public static final int NOTE_TYPE_SCALEBAR = 8;
    public static final int NOTE_TYPE_MERGE = 9;
    public static final int NOTE_TYPE_THRUVIEW = 10;
    public static final int NOTE_TYPE_ARROW = 11;
    public static final int NOTE_TYPE_VARIABLE = 20;
    public static final int NOTE_TYPE_STRUCTURE = 21;
    public static final int NOTE_TYPE_4D_SERIES = 22;
    public static final String[] PIC_SUFFIX = new String[]{"pic"};
    private Vector used;
    private String[] picFiles;
    private byte[][][] lut;
    private int lastChannel;
    private Vector noteStrings;

    public BioRadReader() {
        super("Bio-Rad PIC", new String[]{"pic", "xml", "raw"});
        this.blockCheckLen = 56;
    }

    public boolean isThisType(String name, boolean open) {
        if (BioRadReader.checkSuffix(name, PIC_SUFFIX)) {
            return true;
        }
        String fname = new File(name.toLowerCase()).getName();
        return fname.equals("lse.xml") || fname.equals("data.raw");
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, true)) {
            return false;
        }
        String c = stream.readString(this.blockCheckLen);
        stream.seek(54L);
        return stream.readShort() == 12345 || c.startsWith("[Input Sources]");
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return id.toLowerCase().endsWith(".pic") ? 1 : 0;
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut == null ? (byte[][])null : this.lut[this.lastChannel];
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.used.toArray(new String[0]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        this.lastChannel = this.getZCTCoords(no)[1];
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        if (this.picFiles != null) {
            int file = no % this.picFiles.length;
            RandomAccessStream ras = new RandomAccessStream(this.picFiles[file]);
            long offset = no / this.picFiles.length * this.getSizeX() * this.getSizeY() * bytes;
            ras.seek(offset + 76L);
            this.readPlane(ras, x, y, w, h, buf);
            ras.close();
        } else {
            this.in.seek(no * this.getSizeX() * this.getSizeY() * bytes + 76);
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.used = null;
        this.picFiles = null;
        this.lut = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("BioRadReader.initFile(" + id + ")");
        }
        if (!BioRadReader.checkSuffix(id, PIC_SUFFIX)) {
            Location dir = new Location(id).getAbsoluteFile().getParentFile();
            String[] list = dir.list();
            for (int i = 0; i < list.length; ++i) {
                if (!BioRadReader.checkSuffix(list[i], PIC_SUFFIX)) continue;
                id = new Location(dir.getAbsolutePath(), list[i]).getAbsolutePath();
            }
            if (!BioRadReader.checkSuffix(id, PIC_SUFFIX)) {
                throw new FormatException("No .pic files found - invalid dataset.");
            }
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.in.order(true);
        this.used = new Vector();
        this.used.add(this.currentId);
        this.status("Reading image dimensions");
        this.noteStrings = new Vector();
        this.core[0].sizeX = this.in.readShort();
        this.core[0].sizeY = this.in.readShort();
        short npic = this.in.readShort();
        this.core[0].imageCount = npic;
        short ramp1min = this.in.readShort();
        short ramp1max = this.in.readShort();
        boolean notes = this.in.readInt() != 0;
        this.core[0].pixelType = this.in.readShort() == 0 ? 3 : 1;
        short imageNumber = this.in.readShort();
        String name = this.in.readString(32);
        short merged = this.in.readShort();
        short color1 = this.in.readShort();
        short fileId = this.in.readShort();
        short ramp2min = this.in.readShort();
        short ramp2max = this.in.readShort();
        short color2 = this.in.readShort();
        short edited = this.in.readShort();
        short lens = this.in.readShort();
        float magFactor = this.in.readFloat();
        if (fileId != 12345) {
            throw new FormatException("Invalid file header : " + fileId);
        }
        this.addMeta("nx", this.getSizeX());
        this.addMeta("ny", this.getSizeY());
        this.addMeta("npic", this.getImageCount());
        this.addMeta("ramp1_min", (int)ramp1min);
        this.addMeta("ramp1_max", (int)ramp1max);
        this.addMeta("notes", notes);
        this.addMeta("image_number", (int)imageNumber);
        this.addMeta("name", name);
        this.addMeta("merged", MERGE_NAMES[merged]);
        this.addMeta("color1", (int)color1);
        this.addMeta("file_id", (int)fileId);
        this.addMeta("ramp2_min", (int)ramp2min);
        this.addMeta("ramp2_max", (int)ramp2max);
        this.addMeta("color2", (int)color2);
        this.addMeta("edited", (int)edited);
        this.addMeta("lens", (int)lens);
        this.addMeta("mag_factor", magFactor);
        int imageLen = this.getSizeX() * this.getSizeY();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        this.in.skipBytes(bpp * this.getImageCount() * imageLen + 6);
        this.core[0].sizeZ = this.getImageCount();
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].orderCertain = false;
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = true;
        this.core[0].metadataComplete = true;
        this.core[0].falseColor = true;
        this.status("Reading notes");
        Object zoom = null;
        Object zstart = null;
        Object zstop = null;
        Object mag = null;
        Object gain1 = null;
        Object gain2 = null;
        Object gain3 = null;
        Object offset1 = null;
        Object ex1 = null;
        Object ex2 = null;
        Object ex3 = null;
        Object em1 = null;
        Object em2 = null;
        Object em3 = null;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        int nLasers = 0;
        int noteCount = 0;
        boolean brokenNotes = false;
        while (notes) {
            Note n = new Note();
            n.level = this.in.readShort();
            notes = this.in.readInt() != 0;
            n.num = this.in.readShort();
            n.status = this.in.readShort();
            n.type = this.in.readShort();
            n.x = this.in.readShort();
            n.y = this.in.readShort();
            n.p = this.in.readString(80);
            if (n.type < 0 || n.type >= NOTE_NAMES.length) {
                notes = false;
                brokenNotes = true;
                break;
            }
            int ndx = n.p.length();
            for (int i = 0; i < n.p.length(); ++i) {
                if (n.p.charAt(i) != '\u0000') continue;
                ndx = i;
                break;
            }
            n.p = n.p.substring(0, ndx).trim();
            String value = n.p.replaceAll("=", "");
            Vector<String> v = new Vector<String>();
            StringTokenizer t = new StringTokenizer(value, " ");
            while (t.hasMoreTokens()) {
                String token = t.nextToken().trim();
                if (token.length() <= 0) continue;
                v.add(token);
            }
            String[] tokens = v.toArray(new String[0]);
            try {
                int noteType;
                if (tokens.length > 1 && (noteType = Integer.parseInt(tokens[1])) == 2 && value.indexOf("AXIS_4") != -1) {
                    this.core[0].sizeZ = 1;
                    this.core[0].sizeT = this.getImageCount();
                    this.core[0].orderCertain = true;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            ++noteCount;
            this.noteStrings.add(n);
        }
        this.status("Reading color table");
        int numLuts = 0;
        this.lut = new byte[3][3][256];
        boolean eof = false;
        int next = 0;
        while (!eof && numLuts < 3 && !brokenNotes) {
            if (this.in.getFilePointer() + (long)this.lut[numLuts][next].length <= this.in.length()) {
                this.in.read(this.lut[numLuts][next++]);
                if (next == 3) {
                    next = 0;
                    ++numLuts;
                }
            } else {
                eof = true;
            }
            if (!eof || numLuts != 0) continue;
            this.lut = null;
        }
        if (brokenNotes) {
            this.lut = null;
        }
        if (debug && debugLevel >= 2) {
            this.debug(numLuts + " color table" + (numLuts == 1 ? "" : "s") + " present.");
        }
        this.status("Populating metadata");
        Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
        Object[] list = parent.list();
        Arrays.sort(list);
        Vector<String> pics = new Vector<String>();
        for (int i = 0; i < list.length; ++i) {
            if (((String)list[i]).endsWith("lse.xml")) {
                String path = new Location(parent.getAbsolutePath(), (String)list[i]).getAbsolutePath();
                RandomAccessStream raw = new RandomAccessStream(path);
                this.used.add(path);
                byte[] xml = new byte[(int)raw.length()];
                raw.read(xml);
                raw.close();
                BioRadHandler handler = new BioRadHandler();
                DataTools.parseXML(xml, (DefaultHandler)handler);
                for (int q = 0; q < list.length; ++q) {
                    if (!BioRadReader.checkSuffix((String)list[q], PIC_SUFFIX)) continue;
                    path = new Location(parent.getAbsolutePath(), (String)list[q]).getAbsolutePath();
                    pics.add(path);
                    if (this.used.contains(path)) continue;
                    this.used.add(path);
                }
                continue;
            }
            if (!((String)list[i]).endsWith("data.raw")) continue;
            this.used.add(new Location(parent.getAbsolutePath(), (String)list[i]).getAbsolutePath());
        }
        this.picFiles = pics.toArray(new String[0]);
        this.core[0].indexed = this.lut != null;
        this.core[0].dimensionOrder = "XYCTZ";
        if (this.picFiles.length > 0) {
            this.core[0].imageCount = npic * this.picFiles.length;
            this.core[0].sizeC = this.getImageCount() / (this.getSizeZ() * this.getSizeT());
        } else {
            this.picFiles = null;
        }
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        store.setImageName(name, 0);
        store.setInstrumentID("Instrument:0", 0);
        store.setImageInstrumentRef("Instrument:0", 0);
        store.setObjectiveID("Objective:0", 0, 0);
        store.setObjectiveSettingsObjective("Objective:0", 0);
        store.setObjectiveLensNA(new Float(lens), 0, 0);
        store.setObjectiveNominalMagnification(new Integer((int)magFactor), 0, 0);
        store.setObjectiveCorrection("Unknown", 0, 0);
        store.setObjectiveImmersion("Unknown", 0, 0);
        block53: for (int q = 0; q < this.noteStrings.size(); ++q) {
            Note n = (Note)this.noteStrings.get(q);
            block2 : switch (n.type) {
                case 4: {
                    this.addMeta("Note #" + noteCount, n.toString());
                    break;
                }
                case 8: {
                    this.addMeta("Note #" + noteCount, n.toString());
                    break;
                }
                case 11: {
                    this.addMeta("Note #" + noteCount, n.toString());
                    break;
                }
                case 20: {
                    if (n.p.indexOf("=") >= 0) {
                        String key = n.p.substring(0, n.p.indexOf("=")).trim();
                        String value = n.p.substring(n.p.indexOf("=") + 1).trim();
                        this.addMeta(key, value);
                        if (key.equals("INFO_OBJECTIVE_NAME")) {
                            store.setObjectiveModel(value, 0, 0);
                            break;
                        }
                        if (key.equals("INFO_OBJECTIVE_MAGNIFICATION")) {
                            store.setObjectiveNominalMagnification(new Integer((int)Double.parseDouble(value)), 0, 0);
                            break;
                        }
                        if (key.equals("LENS_MAGNIFICATION")) {
                            store.setObjectiveNominalMagnification(new Integer((int)Double.parseDouble(value)), 0, 0);
                            break;
                        }
                        if (key.startsWith("SETTING")) {
                            if (key.indexOf("_DET_") == -1) break;
                            int index = key.indexOf("_DET_") + 5;
                            if (key.lastIndexOf("_") <= index) break;
                            String idx = key.substring(index, key.indexOf("_", index));
                            int detector = Integer.parseInt(idx) - 1;
                            if (key.endsWith("OFFSET")) {
                                store.setDetectorSettingsOffset(new Float(value), 0, detector);
                            } else if (key.endsWith("GAIN")) {
                                store.setDetectorSettingsGain(new Float(value), 0, detector);
                            }
                            store.setDetectorType("Unknown", 0, detector);
                            store.setDetectorID("Detector:" + detector, 0, detector);
                            store.setDetectorSettingsDetector("Detector:" + detector, 0, detector);
                            break;
                        }
                        String[] values = value.split(" ");
                        if (values.length <= 1) break;
                        try {
                            int type = Integer.parseInt(values[0]);
                            if (type != 257 || values.length < 3) break;
                            float start = Float.parseFloat(values[1]);
                            float end = Float.parseFloat(values[2]);
                            float axisLength = end - start;
                            if (key.equals("AXIS_2")) {
                                float pixelSize = axisLength / (float)this.getSizeX();
                                store.setDimensionsPhysicalSizeX(new Float(pixelSize), 0, 0);
                                break;
                            }
                            if (!key.equals("AXIS_3")) break;
                            float pixelSize = axisLength / (float)this.getSizeY();
                            store.setDimensionsPhysicalSizeY(new Float(pixelSize), 0, 0);
                        }
                        catch (NumberFormatException e) {}
                        break;
                    }
                    this.addMeta("Note #" + noteCount, n.toString());
                    break;
                }
                case 21: {
                    int structureType = (n.x & 0xFF00) >> 8;
                    int version = n.x & 0xFF;
                    String[] values = n.p.split(" ");
                    if (structureType != 1) break;
                    switch (n.y) {
                        case 1: {
                            this.addMeta("Scan Channel", values[0]);
                            this.addMeta("Both mode", values[1]);
                            this.addMeta("Speed", values[2]);
                            this.addMeta("Filter", values[3]);
                            this.addMeta("Factor", values[4]);
                            this.addMeta("Number of scans", values[5]);
                            this.addMeta("Photon counting mode (channel 1)", values[6]);
                            this.addMeta("Photon counting detector (channel 1)", values[7]);
                            this.addMeta("Photon counting mode (channel 2)", values[8]);
                            this.addMeta("Photon counting detector (channel 2)", values[9]);
                            this.addMeta("Photon mode", values[10]);
                            this.addMeta("Objective magnification", values[11]);
                            this.addMeta("Zoom factor", values[12]);
                            this.addMeta("Motor on", values[13]);
                            this.addMeta("Z Step Size", values[14]);
                            store.setObjectiveNominalMagnification(new Integer((int)Double.parseDouble(values[11])), 0, 0);
                            store.setDisplayOptionsZoom(new Float(values[12]), 0);
                            store.setDimensionsPhysicalSizeZ(new Float(values[14]), 0, 0);
                            break;
                        }
                        case 2: {
                            this.addMeta("Z Start", values[0]);
                            this.addMeta("Z Stop", values[1]);
                            this.addMeta("Scan area X coordinate", values[2]);
                            this.addMeta("Scan area Y coordinate", values[3]);
                            this.addMeta("Scan area width", values[4]);
                            this.addMeta("Scan area height", values[5]);
                            float width = Float.parseFloat(values[4]) - Float.parseFloat(values[2]);
                            float height = Float.parseFloat(values[5]) - Float.parseFloat(values[3]);
                            store.setDimensionsPhysicalSizeX(new Float(width /= (float)this.getSizeX()), 0, 0);
                            store.setDimensionsPhysicalSizeY(new Float(height /= (float)this.getSizeY()), 0, 0);
                            break;
                        }
                        case 3: {
                            for (int i = 0; i < 3; ++i) {
                                this.addMeta("Iris for PMT " + (i + 1), values[i * 4]);
                                this.addMeta("Gain for PMT " + (i + 1), values[i * 4 + 1]);
                                this.addMeta("Black level for PMT " + (i + 1), values[i * 4 + 2]);
                                this.addMeta("Emission filter for PMT " + (i + 1), values[i * 4] + 3);
                                this.addMeta("Multiplier for channel " + (i + 1), values[12 + i]);
                            }
                            break block2;
                        }
                        case 4: {
                            int i;
                            nLasers = Integer.parseInt(values[0]);
                            this.addMeta("Number of lasers", values[0]);
                            this.addMeta("Number of transmission detectors", values[1]);
                            this.addMeta("Number of PMTs", values[2]);
                            for (i = 1; i <= 3; ++i) {
                                int idx = (i + 1) * 3;
                                this.addMeta("Shutter present for laser " + i, values[i + 2]);
                                this.addMeta("Neutral density filter for laser " + i, values[idx]);
                                this.addMeta("Excitation filter for laser " + i, values[idx + 1]);
                                this.addMeta("Use laser " + i, values[idx + 2]);
                            }
                            for (i = 0; i < nLasers; ++i) {
                                this.addMeta("Neutral density filter name - laser " + (i + 1), values[15 + i]);
                            }
                            break block2;
                        }
                        case 5: {
                            for (int i = 0; i < nLasers; ++i) {
                                this.addMeta("Excitation filter name - laser " + (i + 1), values[i]);
                            }
                            break block2;
                        }
                        case 6: {
                            for (int i = 0; i < nLasers; ++i) {
                                this.addMeta("Emission filter name - laser " + (i + 1), values[i]);
                            }
                            break block2;
                        }
                        case 7: {
                            for (int i = 0; i < 2; ++i) {
                                String prefix = "Mixer " + i;
                                this.addMeta(prefix + " - enhanced", values[i * 7]);
                                this.addMeta(prefix + " - PMT 1 percentage", values[i * 7 + 1]);
                                this.addMeta(prefix + " - PMT 2 percentage", values[i * 7 + 2]);
                                this.addMeta(prefix + " - PMT 3 percentage", values[i * 7 + 3]);
                                this.addMeta(prefix + " - Transmission 1 percentage", values[i * 7 + 4]);
                                this.addMeta(prefix + " - Transmission 2 percentage", values[i * 7 + 5]);
                                this.addMeta(prefix + " - Transmission 3 percentage", values[i * 7 + 6]);
                            }
                            this.addMeta("Mixer 0 - low signal on", values[14]);
                            this.addMeta("Mixer 1 - low signal on", values[15]);
                            break;
                        }
                        case 8: {
                            this.addMeta("Laser name - laser 1", values[0]);
                            break;
                        }
                        case 9: {
                            this.addMeta("Laser name - laser 2", values[0]);
                            break;
                        }
                        case 10: {
                            this.addMeta("Laser name - laser 3", values[0]);
                            break;
                        }
                        case 11: {
                            for (int i = 0; i < 3; ++i) {
                                this.addMeta("Transmission detector " + (i + 1) + " - offset", values[i * 3]);
                                this.addMeta("Transmission detector " + (i + 1) + " - gain", values[i * 3 + 1]);
                                this.addMeta("Transmission detector " + (i + 1) + " - black level", values[i * 3 + 2]);
                                store.setDetectorOffset(new Float(values[i * 3]), 0, i);
                                store.setDetectorGain(new Float(values[i * 3 + 1]), 0, i);
                                store.setDetectorType("Unknown", 0, i);
                            }
                            break block2;
                        }
                        case 12: {
                            for (int i = 0; i < 2; ++i) {
                                this.addMeta("Part number for laser " + (i + 1), values[i * 4]);
                                this.addMeta("Part number for excitation filter for laser " + (i + 1), values[i * 4 + 1]);
                                this.addMeta("Part number for ND filter for laser " + (i + 1), values[i * 4 + 2]);
                                this.addMeta("Part number for emission filter for laser " + (i + 1), values[i * 4 + 3]);
                            }
                            break block2;
                        }
                        case 13: {
                            this.addMeta("Part number for laser 3", values[0]);
                            this.addMeta("Part number for excitation filter for laser 3", values[1]);
                            this.addMeta("Part number for ND filter for laser 3", values[2]);
                            this.addMeta("Part number for emission filter for laser 3", values[3]);
                            this.addMeta("Part number for filter block 1", values[4]);
                            this.addMeta("Part number for filter block 2", values[5]);
                            break;
                        }
                        case 14: {
                            this.addMeta("Filter Block Name - filter block 1", values[0]);
                            this.addMeta("Filter Block Name - filter block 2", values[1]);
                            break;
                        }
                        case 15: {
                            for (int i = 0; i < 5; ++i) {
                                this.addMeta("Image bands status - band " + (i + 1), values[i * 3]);
                                this.addMeta("Image bands min - band " + (i + 1), values[i * 3 + 1]);
                                this.addMeta("Image bands max - band " + (i + 1), values[i * 3 + 2]);
                                if (!(store instanceof IMinMaxStore)) continue;
                                ((IMinMaxStore)((Object)store)).setChannelGlobalMinMax(i, Double.parseDouble(values[i * 3 + 1]), Double.parseDouble(values[i * 3 + 2]), 0);
                            }
                            break block2;
                        }
                        case 17: {
                            int year = Integer.parseInt(values[5]) + 1900;
                            for (int i = 0; i < 5; ++i) {
                                if (values[i].length() != 1) continue;
                                values[i] = "0" + values[i];
                            }
                            String date = year + "-" + values[4] + "-" + values[3] + "T" + values[2] + ":" + values[1] + ":" + values[0];
                            this.addMeta("Acquisition date", date);
                            store.setImageCreationDate(date, 0);
                            break;
                        }
                        case 18: {
                            this.addMeta("Mixer 3 - enhanced", values[0]);
                            for (int i = 1; i <= 3; ++i) {
                                this.addMeta("Mixer 3 - PMT " + i + " percentage", values[i]);
                                this.addMeta("Mixer 3 - Transmission " + i + " percentage", values[i + 3]);
                                this.addMeta("Mixer 3 - photon counting " + i, values[i + 7]);
                            }
                            this.addMeta("Mixer 3 - low signal on", values[7]);
                            this.addMeta("Mixer 3 - mode", values[11]);
                            break;
                        }
                        case 19: {
                            for (int i = 1; i <= 2; ++i) {
                                String prefix = "Mixer " + i;
                                this.addMeta(prefix + " - photon counting 1", values[i * 4 - 4]);
                                this.addMeta(prefix + " - photon counting 2", values[i * 4 - 3]);
                                this.addMeta(prefix + " - photon counting 3", values[i * 4 - 2]);
                                this.addMeta(prefix + " - mode", values[i * 4 - 1]);
                            }
                            break block2;
                        }
                        case 20: {
                            this.addMeta("Display mode", values[0]);
                            this.addMeta("Course", values[1]);
                            this.addMeta("Time Course - experiment type", values[2]);
                            this.addMeta("Time Course - kd factor", values[3]);
                            store.setExperimentType(values[2], 0);
                            break;
                        }
                        case 21: {
                            this.addMeta("Time Course - ion name", values[0]);
                            break;
                        }
                        case 22: {
                            this.addMeta("PIC file generated on Isoscan (lite)", values[0]);
                            for (int i = 1; i <= 3; ++i) {
                                this.addMeta("Photon counting used (PMT " + i + ")", values[i]);
                                this.addMeta("Hot spot filter used (PMT " + i + ")", values[i + 3]);
                                this.addMeta("Tx Selector used (TX " + i + ")", values[i + 6]);
                            }
                        }
                    }
                    break;
                }
                default: {
                    this.addMeta("Note #" + noteCount, n.toString());
                }
            }
            if (n.p.indexOf("AXIS") == -1) continue;
            n.p = n.p.replaceAll("=", "");
            Vector<String> v = new Vector<String>();
            StringTokenizer tokens = new StringTokenizer(n.p, " ");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (token.length() <= 0) continue;
                v.add(token);
            }
            String[] values = v.toArray(new String[0]);
            String key = values[0];
            String noteType = values[1];
            int axisType = Integer.parseInt(noteType);
            if (values.length <= 2) continue;
            switch (axisType) {
                case 1: {
                    String dx = values[2];
                    String dy = values[3];
                    this.addMeta(key + " distance (X) in microns", dx);
                    this.addMeta(key + " distance (Y) in microns", dy);
                    continue block53;
                }
                case 3: {
                    this.addMeta(key + " angle (X) in degrees", values[2]);
                    this.addMeta(key + " angle (Y) in degrees", values[3]);
                    continue block53;
                }
                case 4: {
                    this.addMeta(key + " intensity (X)", values[2]);
                    this.addMeta(key + " intensity (Y)", values[3]);
                    continue block53;
                }
                case 6: {
                    this.addMeta(key + " ratio (X)", values[2]);
                    this.addMeta(key + " ratio (Y)", values[3]);
                    continue block53;
                }
                case 7: {
                    this.addMeta(key + " log ratio (X)", values[2]);
                    this.addMeta(key + " log ratio (Y)", values[3]);
                    continue block53;
                }
                case 9: {
                    this.addMeta(key + " noncalibrated intensity min", values[2]);
                    this.addMeta(key + " noncalibrated intensity max", values[3]);
                    this.addMeta(key + " calibrated intensity min", values[4]);
                    this.addMeta(key + " calibrated intensity max", values[5]);
                    continue block53;
                }
                case 11: {
                    this.addMeta(key + " RGB type (X)", values[2]);
                    this.addMeta(key + " RGB type (Y)", values[3]);
                    continue block53;
                }
                case 14: {
                    this.addMeta(key + " time course type (X)", values[2]);
                    this.addMeta(key + " time course type (Y)", values[3]);
                    continue block53;
                }
                case 15: {
                    this.addMeta(key + " inverse sigmoid calibrated intensity (min)", values[2]);
                    this.addMeta(key + " inverse sigmoid calibrated intensity (max)", values[3]);
                    this.addMeta(key + " inverse sigmoid calibrated intensity (beta)", values[4]);
                    this.addMeta(key + " inverse sigmoid calibrated intensity (Kd)", values[5]);
                    continue block53;
                }
                case 16: {
                    this.addMeta(key + " log inverse sigmoid calibrated intensity (min)", values[2]);
                    this.addMeta(key + " log inverse sigmoid calibrated intensity (max)", values[3]);
                    this.addMeta(key + " log inverse sigmoid calibrated intensity (beta)", values[4]);
                    this.addMeta(key + " log inverse sigmoid calibrated intensity (Kd)", values[5]);
                }
            }
        }
    }

    class Note {
        public int num;
        public int level;
        public int status;
        public int type;
        public int x;
        public int y;
        public String p;

        Note() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("level=");
            sb.append(this.level);
            sb.append("; num=");
            sb.append(this.num);
            sb.append("; status=");
            sb.append(this.status);
            sb.append("; type=");
            sb.append(NOTE_NAMES[this.type]);
            sb.append("; x=");
            sb.append(this.x);
            sb.append("; y=");
            sb.append(this.y);
            sb.append("; text=");
            sb.append(this.p == null ? "null" : this.p.trim());
            return sb.toString();
        }
    }

    class BioRadHandler
    extends DefaultHandler {
        BioRadHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("Pixels")) {
                String sizeZ = attributes.getValue("SizeZ");
                String sizeC = attributes.getValue("SizeC");
                String sizeT = attributes.getValue("SizeT");
                int z = sizeZ == null ? 1 : Integer.parseInt(sizeZ);
                int c = sizeC == null ? 1 : Integer.parseInt(sizeC);
                int t = sizeT == null ? 1 : Integer.parseInt(sizeT);
                int count = BioRadReader.this.getSizeZ() * BioRadReader.this.getSizeC() * BioRadReader.this.getSizeT();
                ((BioRadReader)BioRadReader.this).core[0].sizeZ = z;
                ((BioRadReader)BioRadReader.this).core[0].sizeC = c;
                ((BioRadReader)BioRadReader.this).core[0].sizeT = t;
                if (count >= BioRadReader.this.getImageCount()) {
                    ((BioRadReader)BioRadReader.this).core[0].imageCount = count;
                } else {
                    ((BioRadReader)BioRadReader.this).core[0].sizeC = BioRadReader.this.getImageCount() / count;
                }
            } else if (qName.equals("Z") || qName.equals("C") || qName.equals("T")) {
                String stamp = attributes.getValue("TimeCompleted");
                int count = 0;
                while (BioRadReader.this.metadata.containsKey("Timestamp " + count)) {
                    ++count;
                }
                BioRadReader.this.addMeta("Timestamp " + count, stamp);
            }
        }
    }
}

