/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import java.util.Arrays;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;

public class LZWCodec
extends BaseCodec {
    private static final int HASH_SIZE = 7349;
    private static final int HASH_STEP = 257;
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private static final int FIRST_CODE = 258;
    private static final int[] COMPR_MASKS = new int[]{255, 127, 63, 31, 15, 7, 3, 1};
    private static final int[] DECOMPR_MASKS = new int[]{0, 1, 3, 7, 15, 31, 63, 127};

    public byte[] compress(byte[] input, CodecOptions options) throws FormatException {
        int tiffK;
        if (input == null || input.length == 0) {
            return input;
        }
        byte[] output = new byte[input.length * 141 / 100 + 3];
        int outSize = 0;
        output[outSize++] = -128;
        int currOutByte = 0;
        int freeBits = 7;
        int[] htKeys = new int[7349];
        int[] htValues = new int[7349];
        Arrays.fill(htKeys, -1);
        int nextCode = 258;
        int currCodeLength = 9;
        int tiffOmega = tiffK = input[0] & 0xFF;
        block11: for (int currInPos = 1; currInPos < input.length; ++currInPos) {
            int shift;
            tiffK = input[currInPos] & 0xFF;
            int hashKey = tiffOmega << 8 | tiffK;
            int hashCode = hashKey % 7349;
            while (true) {
                if (htKeys[hashCode] == hashKey) {
                    tiffOmega = htValues[hashCode];
                    break;
                }
                if (htKeys[hashCode] < 0) {
                    htKeys[hashCode] = hashKey;
                    htValues[hashCode] = nextCode++;
                    shift = currCodeLength - freeBits;
                    output[outSize++] = (byte)(currOutByte << freeBits | tiffOmega >> shift);
                    if (shift > 8) {
                        output[outSize++] = (byte)(tiffOmega >> shift - 8);
                        shift -= 8;
                    }
                    freeBits = 8 - shift;
                    currOutByte = tiffOmega & COMPR_MASKS[freeBits];
                    tiffOmega = tiffK;
                    break;
                }
                hashCode = (hashCode + 257) % 7349;
            }
            switch (nextCode) {
                case 512: {
                    currCodeLength = 10;
                    continue block11;
                }
                case 1024: {
                    currCodeLength = 11;
                    continue block11;
                }
                case 2048: {
                    currCodeLength = 12;
                    continue block11;
                }
                case 4096: {
                    shift = currCodeLength - freeBits;
                    output[outSize++] = (byte)(currOutByte << freeBits | 256 >> shift);
                    if (shift > 8) {
                        output[outSize++] = (byte)(256 >> shift - 8);
                        shift -= 8;
                    }
                    freeBits = 8 - shift;
                    currOutByte = 0x100 & COMPR_MASKS[freeBits];
                    Arrays.fill(htKeys, -1);
                    nextCode = 258;
                    currCodeLength = 9;
                }
            }
        }
        int shift = currCodeLength - freeBits;
        output[outSize++] = (byte)(currOutByte << freeBits | tiffOmega >> shift);
        if (shift > 8) {
            output[outSize++] = (byte)(tiffOmega >> shift - 8);
            shift -= 8;
        }
        freeBits = 8 - shift;
        currOutByte = tiffOmega & COMPR_MASKS[freeBits];
        switch (nextCode) {
            case 511: {
                currCodeLength = 10;
                break;
            }
            case 1023: {
                currCodeLength = 11;
                break;
            }
            case 2047: {
                currCodeLength = 12;
            }
        }
        shift = currCodeLength - freeBits;
        output[outSize++] = (byte)(currOutByte << freeBits | 257 >> shift);
        if (shift > 8) {
            output[outSize++] = (byte)(257 >> shift - 8);
            shift -= 8;
        }
        freeBits = 8 - shift;
        currOutByte = 0x101 & COMPR_MASKS[freeBits];
        output[outSize++] = (byte)(currOutByte << freeBits);
        byte[] result = new byte[outSize];
        System.arraycopy(output, 0, result, 0, outSize);
        return result;
    }

    public byte[] decompress(RandomAccessStream in, CodecOptions options) throws FormatException, IOException {
        if (in == null || in.length() == 0L) {
            return null;
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        byte[] output = new byte[options.maxBytes];
        int currOutPos = 0;
        int[] anotherCodes = new int[4096];
        byte[] newBytes = new byte[4096];
        int[] lengths = new int[4096];
        for (int i = 0; i < 256; ++i) {
            newBytes[i] = (byte)i;
            lengths[i] = 1;
        }
        int currCodeLength = 9;
        int nextCode = 258;
        int currRead = 0;
        int bitsRead = 0;
        int oldCode = 0;
        try {
            do {
                int tablePos;
                int i;
                int outLength;
                int bitsLeft;
                if ((bitsLeft = currCodeLength - bitsRead) > 8) {
                    currRead = currRead << 8 | in.read() & 0xFF;
                    bitsLeft -= 8;
                }
                bitsRead = 8 - bitsLeft;
                int nextByte = in.read() & 0xFF;
                int currCode = currRead << bitsLeft | nextByte >> bitsRead;
                currRead = nextByte & DECOMPR_MASKS[bitsRead];
                if (currCode == 257) break;
                if (currCode == 256) {
                    nextCode = 258;
                    currCodeLength = 9;
                    bitsLeft = currCodeLength - bitsRead;
                    if (bitsLeft > 8) {
                        currRead = currRead << 8 | in.read() & 0xFF;
                        bitsLeft -= 8;
                    }
                    bitsRead = 8 - bitsLeft;
                    nextByte = in.read() & 0xFF;
                    currCode = currRead << bitsLeft | nextByte >> bitsRead;
                    currRead = nextByte & DECOMPR_MASKS[bitsRead];
                    if (currCode == 257) break;
                    output[currOutPos++] = newBytes[currCode];
                    oldCode = currCode;
                } else if (currCode < nextCode) {
                    outLength = lengths[currCode];
                    i = currOutPos + outLength;
                    tablePos = currCode;
                    while (i > currOutPos) {
                        output[--i] = newBytes[tablePos];
                        tablePos = anotherCodes[tablePos];
                    }
                    currOutPos += outLength;
                    anotherCodes[nextCode] = oldCode;
                    newBytes[nextCode] = output[i];
                    lengths[nextCode] = lengths[oldCode] + 1;
                    oldCode = currCode;
                    ++nextCode;
                } else {
                    outLength = lengths[oldCode];
                    i = currOutPos + outLength;
                    tablePos = oldCode;
                    while (i > currOutPos) {
                        output[--i] = newBytes[tablePos];
                        tablePos = anotherCodes[tablePos];
                    }
                    currOutPos += outLength;
                    output[currOutPos++] = output[i];
                    anotherCodes[nextCode] = oldCode;
                    newBytes[nextCode] = output[i];
                    lengths[nextCode] = outLength + 1;
                    oldCode = currCode;
                    ++nextCode;
                }
                switch (nextCode) {
                    case 511: {
                        currCodeLength = 10;
                        break;
                    }
                    case 1023: {
                        currCodeLength = 11;
                        break;
                    }
                    case 2047: {
                        currCodeLength = 12;
                    }
                }
            } while (currOutPos < output.length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new FormatException("Invalid LZW data", e);
        }
        return output;
    }
}

