/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import loci.common.RandomAccessStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.StatusListener;
import loci.formats.meta.MetadataStore;

public abstract class ReaderWrapper
implements IFormatReader {
    protected IFormatReader reader;

    public ReaderWrapper() {
        this(new ImageReader());
    }

    public ReaderWrapper(IFormatReader r) {
        if (r == null) {
            throw new IllegalArgumentException("Format reader cannot be null");
        }
        this.reader = r;
    }

    public IFormatReader getReader() {
        return this.reader;
    }

    public boolean isThisType(byte[] block) {
        return this.reader.isThisType(block);
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return this.reader.isThisType(stream);
    }

    public void setId(String id) throws FormatException, IOException {
        this.reader.setId(id);
    }

    public int getImageCount() {
        return this.reader.getImageCount();
    }

    public boolean isRGB() {
        return this.reader.isRGB();
    }

    public int getSizeX() {
        return this.reader.getSizeX();
    }

    public int getSizeY() {
        return this.reader.getSizeY();
    }

    public int getSizeZ() {
        return this.reader.getSizeZ();
    }

    public int getSizeC() {
        return this.reader.getSizeC();
    }

    public int getSizeT() {
        return this.reader.getSizeT();
    }

    public int getPixelType() {
        return this.reader.getPixelType();
    }

    public int getEffectiveSizeC() {
        return this.getImageCount() / (this.getSizeZ() * this.getSizeT());
    }

    public int getRGBChannelCount() {
        return this.getSizeC() / this.getEffectiveSizeC();
    }

    public boolean isIndexed() {
        return this.reader.isIndexed();
    }

    public boolean isFalseColor() {
        return this.reader.isFalseColor();
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return this.reader.get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return this.reader.get16BitLookupTable();
    }

    public int[] getChannelDimLengths() {
        return this.reader.getChannelDimLengths();
    }

    public String[] getChannelDimTypes() {
        return this.reader.getChannelDimTypes();
    }

    public int getThumbSizeX() {
        return this.reader.getThumbSizeX();
    }

    public int getThumbSizeY() {
        return this.reader.getThumbSizeY();
    }

    public boolean isLittleEndian() {
        return this.reader.isLittleEndian();
    }

    public String getDimensionOrder() {
        return this.reader.getDimensionOrder();
    }

    public boolean isOrderCertain() {
        return this.reader.isOrderCertain();
    }

    public boolean isThumbnailSeries() {
        return this.reader.isThumbnailSeries();
    }

    public boolean isInterleaved() {
        return this.reader.isInterleaved();
    }

    public boolean isInterleaved(int subC) {
        return this.reader.isInterleaved(subC);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        return this.reader.openImage(no);
    }

    public BufferedImage openImage(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return this.reader.openImage(no, x, y, w, h);
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.reader.openBytes(no);
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return this.reader.openBytes(no, x, y, w, h);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.reader.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        return this.reader.openBytes(no, buf, x, y, w, h);
    }

    public BufferedImage openThumbImage(int no) throws FormatException, IOException {
        return this.reader.openThumbImage(no);
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        return this.reader.openThumbBytes(no);
    }

    public void close(boolean fileOnly) throws IOException {
        this.reader.close(fileOnly);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int getSeriesCount() {
        return this.reader.getSeriesCount();
    }

    public void setSeries(int no) {
        this.reader.setSeries(no);
    }

    public int getSeries() {
        return this.reader.getSeries();
    }

    public void setGroupFiles(boolean group) {
        this.reader.setGroupFiles(group);
    }

    public boolean isGroupFiles() {
        return this.reader.isGroupFiles();
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return this.reader.fileGroupOption(id);
    }

    public boolean isMetadataComplete() {
        return this.reader.isMetadataComplete();
    }

    public void setNormalized(boolean normalize) {
        this.reader.setNormalized(normalize);
    }

    public boolean isNormalized() {
        return this.reader.isNormalized();
    }

    public void setMetadataCollected(boolean collect) {
        this.reader.setMetadataCollected(collect);
    }

    public boolean isMetadataCollected() {
        return this.reader.isMetadataCollected();
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        this.reader.setOriginalMetadataPopulated(populate);
    }

    public boolean isOriginalMetadataPopulated() {
        return this.reader.isOriginalMetadataPopulated();
    }

    public String[] getUsedFiles() {
        return this.reader.getUsedFiles();
    }

    public String getCurrentFile() {
        return this.reader.getCurrentFile();
    }

    public int getIndex(int z, int c, int t) {
        return this.reader.getIndex(z, c, t);
    }

    public int[] getZCTCoords(int index) {
        return this.reader.getZCTCoords(index);
    }

    public Object getMetadataValue(String field) {
        return this.reader.getMetadataValue(field);
    }

    public Hashtable getMetadata() {
        return this.reader.getMetadata();
    }

    public CoreMetadata[] getCoreMetadata() {
        return this.reader.getCoreMetadata();
    }

    public void setMetadataFiltered(boolean filter) {
        this.reader.setMetadataFiltered(filter);
    }

    public boolean isMetadataFiltered() {
        return this.reader.isMetadataFiltered();
    }

    public void setMetadataStore(MetadataStore store) {
        this.reader.setMetadataStore(store);
    }

    public MetadataStore getMetadataStore() {
        return this.reader.getMetadataStore();
    }

    public Object getMetadataStoreRoot() {
        return this.reader.getMetadataStoreRoot();
    }

    public IFormatReader[] getUnderlyingReaders() {
        return new IFormatReader[]{this.reader};
    }

    public boolean isThisType(String name) {
        return this.reader.isThisType(name);
    }

    public boolean isThisType(String name, boolean open) {
        return this.reader.isThisType(name, open);
    }

    public String getFormat() {
        return this.reader.getFormat();
    }

    public String[] getSuffixes() {
        return this.reader.getSuffixes();
    }

    public void addStatusListener(StatusListener l) {
        this.reader.addStatusListener(l);
    }

    public void removeStatusListener(StatusListener l) {
        this.reader.removeStatusListener(l);
    }

    public StatusListener[] getStatusListeners() {
        return this.reader.getStatusListeners();
    }
}

