/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.ReaderWrapper;
import loci.formats.meta.MetadataStore;

public class ChannelFiller
extends ReaderWrapper {
    public ChannelFiller() {
    }

    public ChannelFiller(IFormatReader r) {
        super(r);
    }

    public boolean isIndexed() {
        return false;
    }

    public int getSizeC() {
        return this.reader.getSizeC() * (this.reader.isIndexed() && !this.reader.isFalseColor() ? 3 : 1);
    }

    public int getRGBChannelCount() {
        return this.reader.isIndexed() && !this.reader.isFalseColor() ? 3 : this.reader.getRGBChannelCount();
    }

    public boolean isRGB() {
        return this.reader.isIndexed() && !this.reader.isFalseColor() || this.reader.isRGB();
    }

    public byte[][] get8BitLookupTable() {
        try {
            return this.reader.isFalseColor() ? this.reader.get8BitLookupTable() : (byte[][])null;
        }
        catch (FormatException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public short[][] get16BitLookupTable() {
        try {
            return this.reader.isFalseColor() ? this.reader.get16BitLookupTable() : (short[][])null;
        }
        catch (FormatException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        byte[] buf = new byte[w * h * this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType())];
        return this.openBytes(no, buf, x, y, w, h);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.reader.isIndexed() && !this.reader.isFalseColor()) {
            byte[] pix = this.reader.openBytes(no, x, y, w, h);
            if (this.getPixelType() == 1) {
                byte[][] b = ImageTools.indexedToRGB(this.reader.get8BitLookupTable(), pix);
                if (this.isInterleaved()) {
                    int pt = 0;
                    for (int i = 0; i < b[0].length; ++i) {
                        for (int j = 0; j < b.length; ++j) {
                            buf[pt++] = b[j][i];
                        }
                    }
                } else {
                    for (int i = 0; i < b.length; ++i) {
                        System.arraycopy(b[i], 0, buf, i * b[i].length, b[i].length);
                    }
                }
                return buf;
            }
            short[][] s = ImageTools.indexedToRGB(this.reader.get16BitLookupTable(), pix, this.isLittleEndian());
            if (this.isInterleaved()) {
                int pt = 0;
                for (int i = 0; i < s[0].length; ++i) {
                    for (int j = 0; j < s.length; ++j) {
                        buf[pt++] = (byte)(this.isLittleEndian() ? s[j][i] & 0xFF : s[j][i] >> 8);
                        buf[pt++] = (byte)(this.isLittleEndian() ? s[j][i] >> 8 : s[j][i] & 0xFF);
                    }
                }
            } else {
                int pt = 0;
                for (int i = 0; i < s.length; ++i) {
                    for (int j = 0; j < s[i].length; ++j) {
                        buf[pt++] = (byte)(this.isLittleEndian() ? s[i][j] & 0xFF : s[i][j] >> 8);
                        buf[pt++] = (byte)(this.isLittleEndian() ? s[i][j] >> 8 : s[i][j] & 0xFF);
                    }
                }
            }
            return buf;
        }
        return this.reader.openBytes(no, buf, x, y, w, h);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        return this.openImage(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public BufferedImage openImage(int no, int x, int y, int w, int h) throws FormatException, IOException {
        int pixelType = this.getPixelType();
        return AWTImageTools.makeImage(this.openBytes(no, x, y, w, h), w, h, this.getRGBChannelCount(), this.isInterleaved(), FormatTools.getBytesPerPixel(pixelType), FormatTools.isFloatingPoint(pixelType), this.isLittleEndian(), FormatTools.isSigned(pixelType));
    }

    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        MetadataStore store = this.getMetadataStore();
        MetadataTools.populatePixels(store, this);
    }
}

