/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import java.awt.Toolkit;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;

public class NativeLibLoader {
    private static final HashSet loaded = new HashSet();
    private static LoaderAction loaderAction = new DefaultAction();

    public static void disableLoading() {
        NativeLibLoader.setLoadingAction(null);
    }

    public static void enableLoading() {
        NativeLibLoader.setLoadingAction(new DefaultAction());
    }

    public static synchronized void setLoadingAction(LoaderAction loaderAction) {
        NativeLibLoader.loaderAction = loaderAction;
    }

    private static synchronized void loadLibrary(String string, String[] stringArray, boolean bl, boolean bl2) {
        if (loaderAction != null && !loaded.contains(string)) {
            loaderAction.loadLibrary(string, stringArray, bl, bl2);
            loaded.add(string);
        }
    }

    public static void loadCore() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                NativeLibLoader.loadLibrary("jogl", null, false, false);
                return null;
            }
        });
    }

    public static void loadAWTImpl() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Toolkit.getDefaultToolkit();
                boolean bl = System.getProperty("os.name").equals("Mac OS X");
                String[] stringArray = new String[]{"jawt"};
                NativeLibLoader.loadLibrary("jogl_awt", stringArray, !bl, false);
                return null;
            }
        });
    }

    public static void loadCgImpl() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String[] stringArray = new String[]{"cg", "cgGL"};
                NativeLibLoader.loadLibrary("jogl_cg", stringArray, true, true);
                return null;
            }
        });
    }

    private static class DefaultAction
    implements LoaderAction {
        private DefaultAction() {
        }

        public void loadLibrary(String string, String[] stringArray, boolean bl, boolean bl2) {
            if (bl) {
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        System.loadLibrary(stringArray[i]);
                        continue;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (bl2 || unsatisfiedLinkError.getMessage().indexOf("already loaded") >= 0) continue;
                        throw unsatisfiedLinkError;
                    }
                }
            }
            System.loadLibrary(string);
        }
    }

    public static interface LoaderAction {
        public void loadLibrary(String var1, String[] var2, boolean var3, boolean var4);
    }
}

